/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CalculateSchemas<DestinationT>
extends PTransform<PCollection<KV<DestinationT, TableRow>>, PCollectionView<Map<DestinationT, String>>> {
    private static final Logger LOG = LoggerFactory.getLogger(CalculateSchemas.class);
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;

    public CalculateSchemas(DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this.dynamicDestinations = dynamicDestinations;
    }

    public PCollectionView<Map<DestinationT, String>> expand(PCollection<KV<DestinationT, TableRow>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollectionView)((PCollection)((PCollection)((PCollection)input.apply("Keys", (PTransform)Keys.create())).apply("Distinct Keys", (PTransform)Distinct.create())).apply("GetSchemas", (PTransform)ParDo.of((DoFn)new DoFn<DestinationT, KV<DestinationT, String>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                CalculateSchemas.this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
                TableSchema tableSchema = CalculateSchemas.this.dynamicDestinations.getSchema(c.element());
                if (tableSchema != null) {
                    c.output((Object)KV.of((Object)c.element(), (Object)BigQueryHelpers.toJsonString(tableSchema)));
                }
            }
        }).withSideInputs((Iterable)sideInputs))).apply("asMap", (PTransform)View.asMap());
    }
}

