
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Query;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DatastoreV1_Read extends DatastoreV1.Read {

  private final String projectId;
  private final Query query;
  private final String namespace;
  private final int numQuerySplits;

  private AutoValue_DatastoreV1_Read(
      @javax.annotation.Nullable String projectId,
      @javax.annotation.Nullable Query query,
      @javax.annotation.Nullable String namespace,
      int numQuerySplits) {
    this.projectId = projectId;
    this.query = query;
    this.namespace = namespace;
    this.numQuerySplits = numQuerySplits;
  }

  @javax.annotation.Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @javax.annotation.Nullable
  @Override
  public Query getQuery() {
    return query;
  }

  @javax.annotation.Nullable
  @Override
  public String getNamespace() {
    return namespace;
  }

  @Override
  public int getNumQuerySplits() {
    return numQuerySplits;
  }

  @Override
  public String toString() {
    return "Read{"
        + "projectId=" + projectId + ", "
        + "query=" + query + ", "
        + "namespace=" + namespace + ", "
        + "numQuerySplits=" + numQuerySplits
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DatastoreV1.Read) {
      DatastoreV1.Read that = (DatastoreV1.Read) o;
      return ((this.projectId == null) ? (that.getProjectId() == null) : this.projectId.equals(that.getProjectId()))
           && ((this.query == null) ? (that.getQuery() == null) : this.query.equals(that.getQuery()))
           && ((this.namespace == null) ? (that.getNamespace() == null) : this.namespace.equals(that.getNamespace()))
           && (this.numQuerySplits == that.getNumQuerySplits());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (projectId == null) ? 0 : projectId.hashCode();
    h *= 1000003;
    h ^= (query == null) ? 0 : query.hashCode();
    h *= 1000003;
    h ^= (namespace == null) ? 0 : namespace.hashCode();
    h *= 1000003;
    h ^= numQuerySplits;
    return h;
  }

  @Override
  public DatastoreV1.Read.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends DatastoreV1.Read.Builder {
    private String projectId;
    private Query query;
    private String namespace;
    private Integer numQuerySplits;
    Builder() {
    }
    Builder(DatastoreV1.Read source) {
      this.projectId = source.getProjectId();
      this.query = source.getQuery();
      this.namespace = source.getNamespace();
      this.numQuerySplits = source.getNumQuerySplits();
    }
    @Override
    public DatastoreV1.Read.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public DatastoreV1.Read.Builder setQuery(Query query) {
      this.query = query;
      return this;
    }
    @Override
    public DatastoreV1.Read.Builder setNamespace(String namespace) {
      this.namespace = namespace;
      return this;
    }
    @Override
    public DatastoreV1.Read.Builder setNumQuerySplits(int numQuerySplits) {
      this.numQuerySplits = numQuerySplits;
      return this;
    }
    @Override
    public DatastoreV1.Read build() {
      String missing = "";
      if (numQuerySplits == null) {
        missing += " numQuerySplits";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DatastoreV1_Read(
          this.projectId,
          this.query,
          this.namespace,
          this.numQuerySplits);
    }
  }
}
