/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.JsonReadSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public abstract class FileReadSchemaTransformFormatProviderTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TestName testName = new TestName();

    protected abstract String getFormat();

    protected abstract String getStringSchemaFromBeamSchema(Schema var1);

    protected abstract void runWriteAndReadTest(Schema var1, List<Row> var2, String var3, String var4);

    protected Schema getFilepatternSchema() {
        return Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"filepattern", (Schema.FieldType)Schema.FieldType.STRING)});
    }

    protected String getFilePath() {
        return this.getFolder() + "/test";
    }

    protected String getFolder() {
        try {
            return this.tmpFolder.newFolder(new String[]{this.getFormat(), this.testName.getMethodName()}).getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Test
    public void testInvalidConfigsFailToBuild() {
        List<FileReadSchemaTransformConfiguration.Builder> invalidConfigs = Arrays.asList(FileReadSchemaTransformConfiguration.builder().setFormat(this.getFormat()), FileReadSchemaTransformConfiguration.builder().setFormat("invalid format"), FileReadSchemaTransformConfiguration.builder().setFormat(this.getFormat()).setSchema("schema").setTerminateAfterSecondsSinceNewOutput(Long.valueOf(10L)));
        for (FileReadSchemaTransformConfiguration.Builder config : invalidConfigs) {
            Assert.assertThrows(IllegalArgumentException.class, () -> config.build());
        }
    }

    @Test
    public void testAllPrimitiveDataTypes() {
        Schema schema = SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testNullableAllPrimitiveDataTypes() {
        Schema schema = SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.nullableAllPrimitiveDataTypesRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testTimeContaining() {
        Assume.assumeTrue((!this.getFormat().equals("json") ? 1 : 0) != 0);
        Schema schema = SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testByteType() {
        List<String> formatsThatSupportSingleByteType = Arrays.asList("csv", "json", "xml");
        Assume.assumeTrue((boolean)formatsThatSupportSingleByteType.contains(this.getFormat()));
        Schema schema = SchemaAwareJavaBeans.BYTE_TYPE_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.byteTypeRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testByteSequenceType() {
        List<String> formatsThatSupportByteSequenceType = Arrays.asList("avro", "parquet");
        Assume.assumeTrue((boolean)formatsThatSupportByteSequenceType.contains(this.getFormat()));
        Schema schema = SchemaAwareJavaBeans.BYTE_SEQUENCE_TYPE_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.byteSequenceTypeRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testArrayPrimitiveDataTypes() {
        Schema schema = SchemaAwareJavaBeans.ARRAY_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.arrayPrimitiveDataTypesRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testNestedRepeatedDataTypes() {
        Schema schema = SchemaAwareJavaBeans.SINGLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesRepeatedRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testDoublyNestedRepeatedDataTypes() {
        Schema schema = SchemaAwareJavaBeans.DOUBLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesRepeatRows;
        String filePath = this.getFilePath();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testReadWithSchemaFilePath() throws Exception {
        Schema schema = SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows;
        String folder = this.getFolder();
        String filePath = folder + "/test";
        String schemaFilePath = folder + "all_primitive_data_types_schema";
        String schemaString = this.getStringSchemaFromBeamSchema(schema);
        PrintWriter writer = new PrintWriter(schemaFilePath, StandardCharsets.UTF_8.name());
        writer.println(schemaString);
        writer.close();
        this.runWriteAndReadTest(schema, rows, filePath, null);
    }

    @Test
    public void testWriteAndReadWithSchemaTransforms() {
        Schema schema = SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Object> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows;
        String folder = this.getFolder();
        FileWriteSchemaTransformConfiguration writeConfig = FileWriteSchemaTransformConfiguration.builder().setFormat(this.getFormat()).setFilenamePrefix(folder).build();
        if (this.getFormat().equals("parquet")) {
            writeConfig = writeConfig.toBuilder().setParquetConfiguration(FileWriteSchemaTransformConfiguration.parquetConfigurationBuilder().setCompressionCodecName(CompressionCodecName.GZIP.name()).build()).build();
        }
        FileReadSchemaTransformConfiguration readConfig = FileReadSchemaTransformConfiguration.builder().setFormat(this.getFormat()).setSchema(this.getStringSchemaFromBeamSchema(schema)).build();
        SchemaTransform writeTransform = new FileWriteSchemaTransformProvider().from(writeConfig);
        SchemaTransform readTransform = new FileReadSchemaTransformProvider().from(readConfig);
        Schema filePatternSchema = this.getFilepatternSchema();
        PCollection inputRows = (PCollection)this.writePipeline.apply((PTransform)Create.of(rows).withRowSchema(schema));
        PCollection filePatterns = ((PCollection)((PCollectionRowTuple)PCollectionRowTuple.of((String)"input", (PCollection)inputRows).apply((PTransform)writeTransform)).get("output").setRowSchema(FileWriteSchemaTransformProvider.OUTPUT_SCHEMA).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)row -> {
            String file = row.getString("fileName");
            return Row.withSchema((Schema)filePatternSchema).withFieldValue("filepattern", (Object)file).build();
        }))).setRowSchema(filePatternSchema);
        PCollection outputRows = ((PCollectionRowTuple)PCollectionRowTuple.of((String)"input", (PCollection)filePatterns).apply((PTransform)readTransform)).get("output");
        if (this.getFormat().equals("json")) {
            rows = rows.stream().map(row -> JsonReadSchemaTransformFormatProviderTest.getExpectedRow(row)).collect(Collectors.toList());
        }
        PAssert.that((PCollection)outputRows).containsInAnyOrder(rows);
        this.writePipeline.run().waitUntilFinish();
    }
}

