/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.value.AutoValue;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.fileschematransform.AutoValue_FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.AutoValue_FileWriteSchemaTransformConfiguration_CsvConfiguration;
import org.apache.beam.sdk.io.fileschematransform.AutoValue_FileWriteSchemaTransformConfiguration_ParquetConfiguration;
import org.apache.beam.sdk.io.fileschematransform.AutoValue_FileWriteSchemaTransformConfiguration_XmlConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class FileWriteSchemaTransformConfiguration {
    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_FileWriteSchemaTransformConfiguration.Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized CsvConfiguration.Builder csvConfigurationBuilder() {
        return new AutoValue_FileWriteSchemaTransformConfiguration_CsvConfiguration.Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized ParquetConfiguration.Builder parquetConfigurationBuilder() {
        return new AutoValue_FileWriteSchemaTransformConfiguration_ParquetConfiguration.Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized XmlConfiguration.Builder xmlConfigurationBuilder() {
        return new AutoValue_FileWriteSchemaTransformConfiguration_XmlConfiguration.Builder().setCharset(StandardCharsets.UTF_8.name());
    }

    @SchemaFieldDescription(value="The format of the file content. Value must be one of: \"avro\", \"csv\", \"json\", \"parquet\", \"xml\"")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

    @SchemaFieldDescription(value="A common prefix to use for all generated filenames.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFilenamePrefix();

    @SchemaFieldDescription(value="The compression of all generated shard files. By default, appends the respective extension to the filename. Valid options can be found in: https://beam.apache.org/releases/javadoc/2.46.0/org/apache/beam/sdk/io/Compression.html")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getCompression();

    @SchemaFieldDescription(value="The number of output shards produced; a value of 1 disables sharding.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getNumShards();

    @SchemaFieldDescription(value="Uses the given shard name template for naming output files.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getShardNameTemplate();

    @SchemaFieldDescription(value="Configures the filename suffix for written files.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getFilenameSuffix();

    @SchemaFieldDescription(value="Configures extra details related to writing CSV formatted files.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized CsvConfiguration getCsvConfiguration();

    @SchemaFieldDescription(value="Configures extra details related to writing Parquet formatted files.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ParquetConfiguration getParquetConfiguration();

    @SchemaFieldDescription(value="Configures extra details related to writing XML formatted files.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized XmlConfiguration getXmlConfiguration();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class XmlConfiguration {
        @SchemaFieldDescription(value="Sets the enclosing root element for the generated XML files.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getRootElement();

        @SchemaFieldDescription(value="The charset used to write the file. Defaults to UTF_8")
        public abstract @UnknownKeyFor @NonNull @Initialized String getCharset();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setRootElement(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCharset(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized XmlConfiguration build();
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class ParquetConfiguration {
        @SchemaFieldDescription(value="Specifies compression codec. Valid values are: \"GZIP\", \"LZO\", \"SNAPPY\", \"UNCOMPRESSED\"")
        public abstract @UnknownKeyFor @NonNull @Initialized String getCompressionCodecName();

        @SchemaFieldDescription(value="Specify row-group size; if not set or zero, a default is used by the underlying writer.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer getRowGroupSize();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCompressionCodecName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setRowGroupSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ParquetConfiguration build();
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class CsvConfiguration {
        @SchemaFieldDescription(value="The Predefined format of the written CSV file. Valid options can be found in: https://commons.apache.org/proper/commons-csv/apidocs/org/apache/commons/csv/CSVFormat.Predefined.html")
        public abstract @UnknownKeyFor @NonNull @Initialized String getPredefinedCsvFormat();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPredefinedCsvFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized CsvConfiguration build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilenamePrefix(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumShards(@UnknownKeyFor @NonNull @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setShardNameTemplate(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilenameSuffix(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCsvConfiguration(@UnknownKeyFor @NonNull @Initialized CsvConfiguration var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setParquetConfiguration(@UnknownKeyFor @NonNull @Initialized ParquetConfiguration var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setXmlConfiguration(@UnknownKeyFor @NonNull @Initialized XmlConfiguration var1);

        public abstract @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration build();
    }
}

