/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.csv.CsvIO;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileWriteSchemaTransformFormatProvider.class})
public class CsvWriteSchemaTransformFormatProvider
implements FileWriteSchemaTransformFormatProvider {
    final @UnknownKeyFor @NonNull @Initialized String suffix = String.format(".%s", "csv");

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "csv";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> buildTransform(final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new PTransform<PCollection<Row>, PCollectionTuple>(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                int numShards;
                FileWriteSchemaTransformConfiguration.CsvConfiguration csvConfiguration = CsvWriteSchemaTransformFormatProvider.this.getCSVConfiguration(configuration);
                CSVFormat csvFormat = CSVFormat.Predefined.valueOf((String)csvConfiguration.getPredefinedCsvFormat()).getFormat();
                CsvIO.Write write = CsvIO.writeRows((String)configuration.getFilenamePrefix(), (CSVFormat)csvFormat).withSuffix(CsvWriteSchemaTransformFormatProvider.this.suffix);
                if (configuration.getCompression() != null) {
                    write = write.withCompression(FileWriteSchemaTransformFormatProviders.getCompression(configuration));
                }
                if (configuration.getNumShards() != null && (numShards = FileWriteSchemaTransformFormatProviders.getNumShards(configuration).intValue()) > 0) {
                    write = write.withNumShards(Integer.valueOf(numShards));
                }
                if (!Strings.isNullOrEmpty((String)configuration.getShardNameTemplate())) {
                    write = write.withShardTemplate(FileWriteSchemaTransformFormatProviders.getShardNameTemplate(configuration));
                }
                if (!Strings.isNullOrEmpty((String)configuration.getFilenameSuffix())) {
                    write = write.withSuffix(FileWriteSchemaTransformFormatProviders.getFilenameSuffix(configuration));
                }
                WriteFilesResult result = (WriteFilesResult)input.apply("Row to CSV", (PTransform)write);
                PCollection output = (PCollection)result.getPerDestinationOutputFilenames().apply("perDestinationOutputFilenames", (PTransform)Values.create());
                return PCollectionTuple.of(FileWriteSchemaTransformProvider.RESULT_TAG, (PCollection)output);
            }
        };
    }

    private @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration.CsvConfiguration getCSVConfiguration(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<FileWriteSchemaTransformConfiguration.CsvConfiguration> safeCsvConfiguration = Optional.ofNullable(configuration.getCsvConfiguration());
        Preconditions.checkState((boolean)safeCsvConfiguration.isPresent());
        return safeCsvConfiguration.get();
    }
}

