/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.io.fileschematransform.XmlRowValue;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.base.BaseDateTime;
import org.junit.Assert;
import org.junit.Test;

public class XmlRowValueTest {
    @Test
    public void allPrimitiveDataTypes() {
        String aBoolean = "aBoolean";
        String aDecimal = "aDecimal";
        String aDouble = "aDouble";
        String aFloat = "aFloat";
        String anInteger = "anInteger";
        String aLong = "aLong";
        String aString = "aString";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows) {
            XmlRowValue aBooleanValue = new XmlRowValue();
            aBooleanValue.setValue(aBoolean, row);
            Assert.assertEquals((String)aBoolean, (Object)row.getValue(aBoolean), (Object)aBooleanValue.getPrimitiveValue());
            XmlRowValue aDecimalValue = new XmlRowValue();
            aDecimalValue.setValue(aDecimal, row);
            Assert.assertEquals((String)aDecimal, (Object)row.getValue(aDecimal), (Object)aDecimalValue.getPrimitiveValue());
            XmlRowValue aDoubleValue = new XmlRowValue();
            aDoubleValue.setValue(aDouble, row);
            Assert.assertEquals((String)aDouble, (Object)row.getValue(aDouble), (Object)aDoubleValue.getPrimitiveValue());
            XmlRowValue aFloatValue = new XmlRowValue();
            aFloatValue.setValue(aFloat, row);
            Assert.assertEquals((String)aFloat, (Object)row.getValue(aFloat), (Object)aFloatValue.getPrimitiveValue());
            XmlRowValue anIntegerValue = new XmlRowValue();
            anIntegerValue.setValue(anInteger, row);
            Assert.assertEquals((String)anInteger, (Object)row.getValue(anInteger), (Object)anIntegerValue.getPrimitiveValue());
            XmlRowValue aLongValue = new XmlRowValue();
            aLongValue.setValue(aLong, row);
            Assert.assertEquals((String)aLong, (Object)row.getValue(aLong), (Object)aLongValue.getPrimitiveValue());
            XmlRowValue aStringValue = new XmlRowValue();
            aStringValue.setValue(aString, row);
            Assert.assertEquals((String)aString, (Object)row.getValue(aString), (Object)aStringValue.getPrimitiveValue());
        }
    }

    @Test
    public void nullableAllPrimitiveDataTypes() {
        String aBoolean = "aBoolean";
        String aDouble = "aDouble";
        String aFloat = "aFloat";
        String anInteger = "anInteger";
        String aLong = "aLong";
        String aString = "aString";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.nullableAllPrimitiveDataTypesRows) {
            XmlRowValue aBooleanValue = new XmlRowValue();
            aBooleanValue.setValue(aBoolean, row);
            Assert.assertEquals((String)aBoolean, (Object)row.getValue(aBoolean), (Object)aBooleanValue.getPrimitiveValue());
            XmlRowValue aDoubleValue = new XmlRowValue();
            aDoubleValue.setValue(aDouble, row);
            Assert.assertEquals((String)aDouble, (Object)row.getValue(aDouble), (Object)aDoubleValue.getPrimitiveValue());
            XmlRowValue aFloatValue = new XmlRowValue();
            aFloatValue.setValue(aFloat, row);
            Assert.assertEquals((String)aFloat, (Object)row.getValue(aFloat), (Object)aFloatValue.getPrimitiveValue());
            XmlRowValue anIntegerValue = new XmlRowValue();
            anIntegerValue.setValue(anInteger, row);
            Assert.assertEquals((String)anInteger, (Object)row.getValue(anInteger), (Object)anIntegerValue.getPrimitiveValue());
            XmlRowValue aLongValue = new XmlRowValue();
            aLongValue.setValue(aLong, row);
            Assert.assertEquals((String)aLong, (Object)row.getValue(aLong), (Object)aLongValue.getPrimitiveValue());
            XmlRowValue aStringValue = new XmlRowValue();
            aStringValue.setValue(aString, row);
            Assert.assertEquals((String)aString, (Object)row.getValue(aString), (Object)aStringValue.getPrimitiveValue());
        }
    }

    @Test
    public void arrayPrimitiveDataTypes() {
        String booleans = "booleanList";
        String doubles = "doubleList";
        String floats = "floatList";
        String integers = "integerList";
        String longs = "longList";
        String strings = "stringList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.arrayPrimitiveDataTypesRows) {
            XmlRowValue booleansValue = new XmlRowValue();
            booleansValue.setValue(booleans, row);
            Optional<ArrayList> booleansValueList = Optional.ofNullable(booleansValue.getValueList());
            Assert.assertTrue((String)booleans, (boolean)booleansValueList.isPresent());
            Assert.assertEquals((String)booleans, (Object)row.getArray(booleans), booleansValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
            XmlRowValue doublesValue = new XmlRowValue();
            doublesValue.setValue(doubles, row);
            Optional<ArrayList> doublesValueList = Optional.ofNullable(doublesValue.getValueList());
            Assert.assertTrue((String)doubles, (boolean)doublesValueList.isPresent());
            Assert.assertEquals((String)doubles, (Object)row.getArray(doubles), doublesValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
            XmlRowValue floatsValue = new XmlRowValue();
            floatsValue.setValue(floats, row);
            Optional<ArrayList> floatsValueList = Optional.ofNullable(floatsValue.getValueList());
            Assert.assertTrue((String)floats, (boolean)floatsValueList.isPresent());
            Assert.assertEquals((String)floats, (Object)row.getArray(floats), floatsValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
            XmlRowValue integersValue = new XmlRowValue();
            integersValue.setValue(integers, row);
            Optional<ArrayList> integersValueList = Optional.ofNullable(integersValue.getValueList());
            Assert.assertTrue((String)integers, (boolean)integersValueList.isPresent());
            Assert.assertEquals((String)integers, (Object)row.getArray(integers), integersValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
            XmlRowValue longsValue = new XmlRowValue();
            longsValue.setValue(longs, row);
            Optional<ArrayList> longsValueList = Optional.ofNullable(longsValue.getValueList());
            Assert.assertTrue((String)longs, (boolean)longsValueList.isPresent());
            Assert.assertEquals((String)longs, (Object)row.getArray(longs), longsValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
            XmlRowValue stringsValue = new XmlRowValue();
            stringsValue.setValue(strings, row);
            Optional<ArrayList> stringsValueList = Optional.ofNullable(stringsValue.getValueList());
            Assert.assertTrue((String)strings, (boolean)stringsValueList.isPresent());
            Assert.assertEquals((String)strings, (Object)row.getArray(strings), stringsValueList.get().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
        }
    }

    @Test
    public void timeContaining() {
        String instant = "instant";
        String instantList = "instantList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows) {
            XmlRowValue instantValue = new XmlRowValue();
            instantValue.setValue(instant, row);
            Optional<ReadableDateTime> expected = Optional.ofNullable(row.getDateTime(instant));
            Optional<DateTime> actual = Optional.ofNullable(instantValue.getDateTimeValue());
            Assert.assertTrue((String)instant, (boolean)expected.isPresent());
            Assert.assertTrue((String)instant, (boolean)actual.isPresent());
            Assert.assertEquals((String)instant, (long)expected.get().getMillis(), (long)actual.get().getMillis());
            XmlRowValue instantListValue = new XmlRowValue();
            instantListValue.setValue(instantList, row);
            Optional<Collection> expectedList = Optional.ofNullable(row.getArray(instantList));
            Optional<ArrayList> actualList = Optional.ofNullable(instantListValue.getValueList());
            Assert.assertTrue((String)instantList, (boolean)expectedList.isPresent());
            Assert.assertTrue((String)instantList, (boolean)actualList.isPresent());
            Assert.assertFalse((String)instantList, (boolean)expectedList.get().isEmpty());
            Assert.assertFalse((String)instantList, (boolean)((List)actualList.get()).isEmpty());
            Assert.assertEquals((String)instantList, expectedList.get().stream().map(Instant::getMillis).collect(Collectors.toList()), XmlRowValueTest.dateTimes(actualList.get()).stream().map(BaseDateTime::getMillis).collect(Collectors.toList()));
        }
    }

    @Test
    public void byteType() {
        String singleByte = "byte";
        String byteList = "byteList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.byteTypeRows) {
            XmlRowValue byteValue = new XmlRowValue();
            byteValue.setValue(singleByte, row);
            Assert.assertEquals((String)singleByte, (Object)row.getValue(singleByte), (Object)byteValue.getPrimitiveValue());
            XmlRowValue byteListValue = new XmlRowValue();
            byteListValue.setValue(byteList, row);
            Assert.assertEquals((String)singleByte, (Object)row.getArray(byteList), byteListValue.getValueList().stream().map(XmlRowValue::getPrimitiveValue).collect(Collectors.toList()));
        }
    }

    @Test
    public void singlyNestedDataTypesNoRepeat() {
        String allPrimitiveDataTypes = "allPrimitiveDataTypes";
        String allPrimitiveDataTypesList = "allPrimitiveDataTypesList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesNoRepeatRows) {
            XmlRowValue allPrimitiveDataTypesValue = new XmlRowValue();
            allPrimitiveDataTypesValue.setValue(allPrimitiveDataTypes, row);
            Optional<Row> expectedAllPrimitiveDataTypes = Optional.ofNullable(row.getRow(allPrimitiveDataTypes));
            Optional<HashMap> actualAllPrimitiveDataTypes = Optional.ofNullable(allPrimitiveDataTypesValue.getNestedValue());
            Assert.assertTrue((String)allPrimitiveDataTypes, (boolean)expectedAllPrimitiveDataTypes.isPresent());
            Assert.assertTrue((String)allPrimitiveDataTypes, (boolean)actualAllPrimitiveDataTypes.isPresent());
            Assert.assertEquals((String)allPrimitiveDataTypes, XmlRowValueTest.values(expectedAllPrimitiveDataTypes.get()), XmlRowValueTest.values(actualAllPrimitiveDataTypes.get()));
            XmlRowValue allPrimitiveDataTypesValueList = new XmlRowValue();
            allPrimitiveDataTypesValueList.setValue(allPrimitiveDataTypesList, row);
            Optional<Collection> expectedAllPrimitiveDataTypesList = Optional.ofNullable(row.getArray(allPrimitiveDataTypesList));
            Optional<ArrayList> actualAllPrimitiveDataTypesList = Optional.ofNullable(allPrimitiveDataTypesValueList.getValueList());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)expectedAllPrimitiveDataTypesList.isPresent());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)actualAllPrimitiveDataTypesList.isPresent());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)expectedAllPrimitiveDataTypesList.get().isEmpty());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)actualAllPrimitiveDataTypesList.get().isEmpty());
        }
    }

    @Test
    public void singlyNestedDataTypesRepeat() {
        String allPrimitiveDataTypes = "allPrimitiveDataTypes";
        String allPrimitiveDataTypesList = "allPrimitiveDataTypesList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesRepeatedRows) {
            XmlRowValue allPrimitiveDataTypesValue = new XmlRowValue();
            allPrimitiveDataTypesValue.setValue(allPrimitiveDataTypes, row);
            Optional<Row> expectedAllPrimitiveDataTypes = Optional.ofNullable(row.getRow(allPrimitiveDataTypes));
            Optional<HashMap> actualAllPrimitiveDataTypes = Optional.ofNullable(allPrimitiveDataTypesValue.getNestedValue());
            Assert.assertTrue((String)allPrimitiveDataTypes, (boolean)expectedAllPrimitiveDataTypes.isPresent());
            Assert.assertTrue((String)allPrimitiveDataTypes, (boolean)actualAllPrimitiveDataTypes.isPresent());
            Assert.assertEquals((String)allPrimitiveDataTypes, XmlRowValueTest.values(expectedAllPrimitiveDataTypes.get()), XmlRowValueTest.values(actualAllPrimitiveDataTypes.get()));
            XmlRowValue allPrimitiveDataTypesValueList = new XmlRowValue();
            allPrimitiveDataTypesValueList.setValue(allPrimitiveDataTypesList, row);
            Optional<Collection> expectedAllPrimitiveDataTypesList = Optional.ofNullable(row.getArray(allPrimitiveDataTypesList));
            Optional<ArrayList> actualAllPrimitiveDataTypesList = Optional.ofNullable(allPrimitiveDataTypesValueList.getValueList());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)expectedAllPrimitiveDataTypesList.isPresent());
            Assert.assertTrue((String)allPrimitiveDataTypesList, (boolean)actualAllPrimitiveDataTypesList.isPresent());
            Assert.assertFalse((String)allPrimitiveDataTypesList, (boolean)expectedAllPrimitiveDataTypesList.get().isEmpty());
            Assert.assertFalse((String)allPrimitiveDataTypesList, (boolean)((List)actualAllPrimitiveDataTypesList.get()).isEmpty());
            Assert.assertEquals((String)allPrimitiveDataTypesList, XmlRowValueTest.valuesList(expectedAllPrimitiveDataTypesList.get()), XmlRowValueTest.valuesList(actualAllPrimitiveDataTypesList.get()));
        }
    }

    @Test
    public void doublyNestedDataTypesNoRepeat() {
        String singlyNestedDataTypes = "singlyNestedDataTypes";
        String allPrimitiveDataTypes = "allPrimitiveDataTypes";
        String allPrimitiveDataTypesList = "allPrimitiveDataTypesList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesNoRepeatRows) {
            XmlRowValue singlyNestedDataTypesValue = new XmlRowValue();
            singlyNestedDataTypesValue.setValue(singlyNestedDataTypes, row);
            Optional<Row> expectedSinglyNestedDataTypesValue = Optional.ofNullable(row.getRow(singlyNestedDataTypes));
            Optional<HashMap> actualSinglyNestedDataTypesValue = Optional.ofNullable(singlyNestedDataTypesValue.getNestedValue());
            Assert.assertTrue((String)singlyNestedDataTypes, (boolean)expectedSinglyNestedDataTypesValue.isPresent());
            Assert.assertTrue((String)singlyNestedDataTypes, (boolean)actualSinglyNestedDataTypesValue.isPresent());
            Assert.assertNotNull((String)singlyNestedDataTypes, (Object)expectedSinglyNestedDataTypesValue.get().getValue(allPrimitiveDataTypes));
            Assert.assertNotNull((String)singlyNestedDataTypes, ((Map)actualSinglyNestedDataTypesValue.get()).get(allPrimitiveDataTypes));
            Assert.assertNotNull((String)singlyNestedDataTypes, (Object)expectedSinglyNestedDataTypesValue.get().getValue(allPrimitiveDataTypesList));
            Assert.assertNotNull((String)singlyNestedDataTypes, ((Map)actualSinglyNestedDataTypesValue.get()).get(allPrimitiveDataTypesList));
        }
    }

    private static Map<String, Object> values(Row row) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Schema schema = row.getSchema();
        for (String key : schema.getFieldNames()) {
            result.put(key, row.getValue(key));
        }
        return result;
    }

    private static List<Map<String, Object>> valuesList(Collection<Row> values) {
        return values.stream().map(XmlRowValueTest::values).collect(Collectors.toList());
    }

    private static Map<String, Object> values(Map<String, XmlRowValue> nested) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : nested.keySet()) {
            result.put(key, nested.get(key).getPrimitiveValue());
        }
        return result;
    }

    private static List<Map<String, Object>> valuesList(List<XmlRowValue> nestedList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (XmlRowValue item : nestedList) {
            Optional<HashMap> nestedValues = Optional.ofNullable(item.getNestedValue());
            nestedValues.ifPresent(stringXmlRowValueMap -> result.add(XmlRowValueTest.values(stringXmlRowValueMap)));
        }
        return result;
    }

    private static List<DateTime> dateTimes(List<XmlRowValue> dateTimeValues) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        for (XmlRowValue item : dateTimeValues) {
            Optional<DateTime> value = Optional.ofNullable(item.getDateTimeValue());
            value.ifPresent(result::add);
        }
        return result;
    }
}

