/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.fileschematransform.AvroWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.JsonWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.ParquetWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.XmlWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileWriteSchemaTransformProviderTest {
    private static final FileWriteSchemaTransformProvider PROVIDER = new FileWriteSchemaTransformProvider();
    @Rule
    public TestPipeline errorPipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Test
    public void receivedUnexpectedInputTagsThrowsAnError() {
        SchemaTransform transform = PROVIDER.from(FileWriteSchemaTransformProviderTest.defaultConfiguration().setFormat("json").build());
        PCollectionRowTuple empty = PCollectionRowTuple.empty((Pipeline)this.errorPipeline);
        IllegalArgumentException emptyInputError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            PCollectionRowTuple cfr_ignored_0 = (PCollectionRowTuple)empty.apply((PTransform)transform);
        });
        Assert.assertEquals((Object)"org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider$FileWriteSchemaTransform expects a single input tagged PCollection<Row> input", (Object)emptyInputError.getMessage());
        PCollection rows1 = (PCollection)this.errorPipeline.apply((PTransform)Create.of(FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        PCollection rows2 = (PCollection)this.errorPipeline.apply((PTransform)Create.of(FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows).withRowSchema(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA));
        PCollectionRowTuple tooManyTags = PCollectionRowTuple.of((String)"input", (PCollection)rows1).and("another", rows2);
        IllegalArgumentException tooManyTagsError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            PCollectionRowTuple cfr_ignored_0 = (PCollectionRowTuple)tooManyTags.apply((PTransform)transform);
        });
        Assert.assertEquals((Object)"org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider$FileWriteSchemaTransform expects a single input tagged PCollection<Row> input", (Object)tooManyTagsError.getMessage());
        PCollectionRowTuple input = PCollectionRowTuple.of((String)"input", (PCollection)rows1);
        input.apply((PTransform)transform);
    }

    @Test
    public void formatMapsToFileWriteSchemaFormatTransform() {
        FileWriteSchemaTransformFormatProvider avroFormatProvider = ((FileWriteSchemaTransformProvider.FileWriteSchemaTransform)PROVIDER.from(FileWriteSchemaTransformProviderTest.defaultConfiguration().setFormat("avro").build())).getProvider();
        Assert.assertTrue((boolean)(avroFormatProvider instanceof AvroWriteSchemaTransformFormatProvider));
        FileWriteSchemaTransformFormatProvider jsonFormatProvider = ((FileWriteSchemaTransformProvider.FileWriteSchemaTransform)PROVIDER.from(FileWriteSchemaTransformProviderTest.defaultConfiguration().setFormat("json").build())).getProvider();
        Assert.assertTrue((boolean)(jsonFormatProvider instanceof JsonWriteSchemaTransformFormatProvider));
        FileWriteSchemaTransformFormatProvider parquetFormatProvider = ((FileWriteSchemaTransformProvider.FileWriteSchemaTransform)PROVIDER.from(FileWriteSchemaTransformProviderTest.defaultConfiguration().setFormat("parquet").build())).getProvider();
        Assert.assertTrue((boolean)(parquetFormatProvider instanceof ParquetWriteSchemaTransformFormatProvider));
        FileWriteSchemaTransformFormatProvider xmlFormatProvider = ((FileWriteSchemaTransformProvider.FileWriteSchemaTransform)PROVIDER.from(FileWriteSchemaTransformProviderTest.defaultConfiguration().setFormat("xml").build())).getProvider();
        Assert.assertTrue((boolean)(xmlFormatProvider instanceof XmlWriteSchemaTransformFormatProvider));
    }

    private static FileWriteSchemaTransformConfiguration.Builder defaultConfiguration() {
        return FileWriteSchemaTransformConfiguration.builder().setFilenamePrefix(FileWriteSchemaTransformProviderTest.class.getSimpleName());
    }
}

