/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileWriteSchemaTransformFormatProvidersTest {
    @Rule
    public TestPipeline p = TestPipeline.create();
    private static final TupleTag<String> OUTPUT_TAG = new TupleTag<String>(){};
    private static final TupleTag<Row> ERROR_TAG = FileWriteSchemaTransformProvider.ERROR_TAG;
    private static final Schema BEAM_SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING)});
    private static final Schema ERROR_SCHEMA = FileWriteSchemaTransformProvider.ERROR_SCHEMA;
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"a").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"b").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"c").build());
    private static final String DLQ_MSG = "Testing DLQ behavior";
    private static final String NO_DLQ_MSG = "Testing without DLQ";

    @Test
    public void loadProviders() {
        Map formatProviderMap = FileWriteSchemaTransformFormatProviders.loadProviders();
        Set keys = formatProviderMap.keySet();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"avro", (Object)"csv", (Object)"json", (Object)"parquet", (Object)"xml"), keys);
    }

    @Test
    public void testErrorCounterSuccess() {
        SimpleMapFn mapFn = new SimpleMapFn(false);
        List<String> records = Arrays.asList(NO_DLQ_MSG, NO_DLQ_MSG, NO_DLQ_MSG);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Generic-write-error-counter", (SerializableFunction)mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PAssert.that((PCollection)output.get(OUTPUT_TAG)).containsInAnyOrder(records);
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testErrorCounterDlqSuccess() {
        SimpleMapFn mapFn = new SimpleMapFn(true);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Generic-write-error-counter", (SerializableFunction)mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PCollection count = (PCollection)output.get(ERROR_TAG).apply(Count.globally());
        PAssert.that((PCollection)count).containsInAnyOrder(Collections.singletonList(3L));
        this.p.run().waitUntilFinish();
    }

    private static class SimpleMapFn
    implements SerializableFunction<Row, String> {
        private boolean useDlq;

        SimpleMapFn(boolean useDlq) {
            this.useDlq = useDlq;
        }

        public String apply(Row row) {
            if (this.useDlq) {
                throw new IllegalArgumentException(FileWriteSchemaTransformFormatProvidersTest.DLQ_MSG);
            }
            return FileWriteSchemaTransformFormatProvidersTest.NO_DLQ_MSG;
        }
    }
}

