/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.XmlRowAdapter;
import org.apache.beam.sdk.io.fileschematransform.XmlWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XmlWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    private static final String ROOT_ELEMENT = "rootElement";
    private static final String RECORD_ELEMENT = "row";
    private static final TupleTag<XmlRowAdapter> OUTPUT_TAG = XmlWriteSchemaTransformFormatProvider.ERROR_FN_OUPUT_TAG;
    private static final TupleTag<Row> ERROR_TAG = FileWriteSchemaTransformProvider.ERROR_TAG;
    private static final Schema BEAM_SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING)});
    private static final Schema ERROR_SCHEMA = FileWriteSchemaTransformProvider.ERROR_SCHEMA;
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"a").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"b").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"c").build());

    @Override
    protected String getFormat() {
        return "xml";
    }

    @Override
    protected String getFilenamePrefix() {
        return "";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, Schema beamSchema) {
        List expected = rows.stream().map(row -> {
            XmlRowAdapter result = new XmlRowAdapter();
            result.wrapRow(row);
            return result;
        }).collect(Collectors.toList());
        PCollection actual = (PCollection)this.readPipeline.apply((PTransform)XmlIO.read().from(folder + "/*").withRecordClass(XmlRowAdapter.class).withRootElement(ROOT_ELEMENT).withRecordElement(RECORD_ELEMENT).withCharset(Charset.defaultCharset()));
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return FileWriteSchemaTransformConfiguration.builder().setFormat("xml").setXmlConfiguration(FileWriteSchemaTransformConfiguration.xmlConfigurationBuilder().setRootElement(ROOT_ELEMENT).build()).setFilenamePrefix(folder).setNumShards(Integer.valueOf(1)).build();
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$ParquetConfiguration is not compatible with a xml format");
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$CsvConfiguration is not compatible with a xml format");
    }

    @Test
    public void testXmlErrorCounterSuccess() {
        XmlWriteSchemaTransformFormatProvider.RowToXmlFn mapFn = new XmlWriteSchemaTransformFormatProvider.RowToXmlFn();
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Xml-write-error-counter", (SerializableFunction)mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PCollection count = (PCollection)output.get(OUTPUT_TAG).apply(Count.globally());
        PAssert.that((PCollection)count).containsInAnyOrder(Collections.singleton(3L));
        this.writePipeline.run().waitUntilFinish();
    }
}

