/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.apache.commons.csv.CSVFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

abstract class FileWriteSchemaTransformFormatProviderTest {
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    FileWriteSchemaTransformFormatProviderTest() {
    }

    protected abstract String getFormat();

    protected abstract String getFilenamePrefix();

    protected abstract void assertFolderContainsInAnyOrder(String var1, List<Row> var2, Schema var3);

    protected abstract FileWriteSchemaTransformConfiguration buildConfiguration(String var1);

    protected abstract Optional<String> expectedErrorWhenCompressionSet();

    @Test
    public void withCompression() {
        String to = this.folder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class, "with_compression");
        Compression compression = Compression.GZIP;
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setCompression(compression.name()).build();
        FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
        if (this.expectedErrorWhenCompressionSet().isPresent()) {
            IllegalArgumentException invalidConfiguration = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
            Assert.assertEquals((Object)this.expectedErrorWhenCompressionSet().get(), (Object)invalidConfiguration.getMessage());
            return;
        }
        PCollection<String> files = this.applyProviderAndAssertFilesWritten(FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows, SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, configuration);
        PCollection extension = (PCollection)((PCollection)files.apply("extract extension", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)fullName -> fullName != null ? Files.getFileExtension((String)fullName) : null))).apply("distinct extensions", (PTransform)Distinct.create());
        PCollection isCompressed = (PCollection)((PCollection)files.apply("isCompressed", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.booleans()).via((SerializableFunction & Serializable)filename -> filename != null && compression.isCompressed(filename)))).apply("distinct isCompressed", (PTransform)Distinct.create());
        PAssert.thatSingleton((String)"Filenames end with compression name", (PCollection)extension).isEqualTo((Object)"gz");
        PAssert.thatSingleton((String)"Files should be compressed", (PCollection)isCompressed).isEqualTo((Object)true);
        this.writePipeline.run();
    }

    protected abstract Optional<String> expectedErrorWhenParquetConfigurationSet();

    @Test
    public void invalidConfigurationWithParquet() {
        String to = this.folder(this.getFormat(), "configuration_with_parquet");
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setParquetConfiguration(FileWriteSchemaTransformConfiguration.parquetConfigurationBuilder().setCompressionCodecName(CompressionCodecName.GZIP.name()).build()).build();
        FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
        if (!this.expectedErrorWhenParquetConfigurationSet().isPresent()) {
            provider.from(configuration);
            return;
        }
        IllegalArgumentException invalidConfigurationError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
        Assert.assertEquals((Object)this.expectedErrorWhenParquetConfigurationSet().get(), (Object)invalidConfigurationError.getMessage());
    }

    protected abstract Optional<String> expectedErrorWhenXmlConfigurationSet();

    @Test
    public void invalidConfigurationWithXml() {
        String to = this.folder(this.getFormat(), "configuration_with_xml");
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setXmlConfiguration(FileWriteSchemaTransformConfiguration.xmlConfigurationBuilder().setRootElement("rootElement").setCharset(Charset.defaultCharset().name()).build()).build();
        FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
        if (!this.expectedErrorWhenXmlConfigurationSet().isPresent()) {
            provider.from(configuration);
            return;
        }
        IllegalArgumentException configurationError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
        Assert.assertEquals((Object)this.expectedErrorWhenXmlConfigurationSet().get(), (Object)configurationError.getMessage());
    }

    protected abstract Optional<String> expectedErrorWhenNumShardsSet();

    @Test
    public void numShardsSetConfiguration() {
        String to = this.folder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class, "num_shards_configuration");
        int expectedNumShards = 10;
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setNumShards(Integer.valueOf(expectedNumShards)).build();
        if (this.expectedErrorWhenNumShardsSet().isPresent()) {
            FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
            IllegalArgumentException configurationError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
            Assert.assertEquals((Object)this.expectedErrorWhenNumShardsSet().get(), (Object)configurationError.getMessage());
            return;
        }
        ArrayList<Row> rows = new ArrayList<Row>(FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows);
        for (int i = 0; i < 100; ++i) {
            rows.addAll(FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows);
        }
        PCollection<String> files = this.applyProviderAndAssertFilesWritten(rows, SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, configuration);
        PCollection count = (PCollection)files.apply(Count.globally());
        PAssert.thatSingleton((String)"Amount of files created should match numShards", (PCollection)count).isEqualTo((Object)Integer.valueOf(expectedNumShards).longValue());
        this.writePipeline.run();
    }

    protected abstract Optional<String> expectedErrorWhenShardNameTemplateSet();

    @Test
    public void shardNameTemplateSetConfiguration() {
        String to = this.folder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class, "shard_name_template");
        String shardNameTemplate = "-SS-of-NN";
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setShardNameTemplate(shardNameTemplate).build();
        if (this.expectedErrorWhenShardNameTemplateSet().isPresent()) {
            FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
            IllegalArgumentException configurationError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
            Assert.assertEquals((Object)this.expectedErrorWhenShardNameTemplateSet().get(), (Object)configurationError.getMessage());
            return;
        }
        PCollection<String> files = this.applyProviderAndAssertFilesWritten(FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows, SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, configuration);
        PAssert.that((String)"All file names match shard name template", files).satisfies((SerializableFunction & Serializable)names -> {
            Assert.assertNotNull((Object)names);
            for (String name : names) {
                Assert.assertTrue((boolean)name.matches("^.*\\d\\d-of-\\d\\d.*$"));
            }
            return null;
        });
        this.writePipeline.run();
    }

    protected abstract Optional<String> expectedErrorWhenCsvConfigurationSet();

    @Test
    public void csvConfigurationSet() {
        String to = this.folder(this.getFormat(), "csv_configuration");
        FileWriteSchemaTransformProvider provider = new FileWriteSchemaTransformProvider();
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(to).toBuilder().setCsvConfiguration(FileWriteSchemaTransformConfiguration.csvConfigurationBuilder().setPredefinedCsvFormat(CSVFormat.Predefined.Default.name()).build()).build();
        if (!this.expectedErrorWhenCsvConfigurationSet().isPresent()) {
            provider.from(configuration);
            return;
        }
        IllegalArgumentException configurationError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> provider.from(configuration));
        Assert.assertEquals((Object)this.expectedErrorWhenCsvConfigurationSet().get(), (Object)configurationError.getMessage());
    }

    @Test
    public void allPrimitiveDataTypes() {
        String to = this.folder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class);
        Schema schema = SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void nullableAllPrimitiveDataTypes() {
        String to = this.folder(SchemaAwareJavaBeans.NullableAllPrimitiveDataTypes.class);
        Schema schema = SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.nullableAllPrimitiveDataTypesRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void timeContaining() {
        String to = this.folder(SchemaAwareJavaBeans.TimeContaining.class);
        Schema schema = SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void byteTypes() {
        List<String> formatsThatSupportSingleByteType = Arrays.asList("json", "xml");
        Assume.assumeTrue((boolean)formatsThatSupportSingleByteType.contains(this.getFormat()));
        String to = this.folder(SchemaAwareJavaBeans.ByteType.class);
        Schema schema = SchemaAwareJavaBeans.BYTE_TYPE_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.byteTypeRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void byteSequenceTypes() {
        List<String> formatsThatSupportByteSequenceType = Arrays.asList("avro", "parquet");
        Assume.assumeTrue((boolean)formatsThatSupportByteSequenceType.contains(this.getFormat()));
        String to = this.folder(SchemaAwareJavaBeans.ByteSequenceType.class);
        Schema schema = SchemaAwareJavaBeans.BYTE_SEQUENCE_TYPE_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.byteSequenceTypeRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void arrayPrimitiveDataTypes() {
        String to = this.folder(SchemaAwareJavaBeans.ArrayPrimitiveDataTypes.class);
        Schema schema = SchemaAwareJavaBeans.ARRAY_PRIMITIVE_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.arrayPrimitiveDataTypesRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void singlyNestedDataTypesNoRepeat() {
        String to = this.folder(SchemaAwareJavaBeans.SinglyNestedDataTypes.class, "no_repeat");
        Schema schema = SchemaAwareJavaBeans.SINGLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesNoRepeatRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void singlyNestedDataTypesRepeated() {
        String to = this.folder(SchemaAwareJavaBeans.SinglyNestedDataTypes.class, "repeated");
        Schema schema = SchemaAwareJavaBeans.SINGLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesNoRepeatRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void doublyNestedDataTypesNoRepeat() {
        String to = this.folder(SchemaAwareJavaBeans.DoublyNestedDataTypes.class, "no_repeat");
        Schema schema = SchemaAwareJavaBeans.DOUBLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesNoRepeatRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    @Test
    public void doublyNestedDataTypesRepeat() {
        String to = this.folder(SchemaAwareJavaBeans.DoublyNestedDataTypes.class, "repeated");
        Schema schema = SchemaAwareJavaBeans.DOUBLY_NESTED_DATA_TYPES_SCHEMA;
        List<Row> rows = FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesRepeatRows;
        this.applyProviderAndAssertFilesWritten(to, rows, schema);
        this.writePipeline.run().waitUntilFinish();
        this.assertFolderContainsInAnyOrder(to, rows, schema);
        this.readPipeline.run();
    }

    protected FileWriteSchemaTransformFormatProvider getProvider() {
        return (FileWriteSchemaTransformFormatProvider)FileWriteSchemaTransformFormatProviders.loadProviders().get(this.getFormat());
    }

    protected <T> String folder(Class<T> clazz, String additionalPath) {
        return this.folder(this.getFormat(), clazz.getSimpleName(), additionalPath);
    }

    private <T> String folder(Class<T> clazz) {
        return this.folder(this.getFormat(), clazz.getSimpleName());
    }

    private String folder(String ... paths) {
        try {
            return this.tmpFolder.newFolder(paths).getAbsolutePath() + this.getFilenamePrefix();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private PCollection<String> applyProviderAndAssertFilesWritten(String folder, List<Row> rows, Schema schema) {
        return this.applyProviderAndAssertFilesWritten(rows, schema, this.buildConfiguration(folder));
    }

    private PCollection<String> applyProviderAndAssertFilesWritten(List<Row> rows, Schema schema, FileWriteSchemaTransformConfiguration configuration) {
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(rows).withRowSchema(schema));
        PCollection files = ((PCollectionTuple)input.apply(this.getProvider().buildTransform(configuration, schema))).get(FileWriteSchemaTransformProvider.RESULT_TAG);
        PCollection count = (PCollection)files.apply("count number of files", Count.globally());
        PAssert.thatSingleton((String)"At least one file should be written", (PCollection)count).notEqualTo((Object)0L);
        return files;
    }

    protected FileWriteSchemaTransformConfiguration defaultConfiguration(String folder) {
        return FileWriteSchemaTransformConfiguration.builder().setFormat(this.getFormat()).setFilenamePrefix(folder).build();
    }
}

