/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.beam.sdk.io.fileschematransform.XmlDateTimeAdapter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;

@XmlType
class XmlRowValue
implements Serializable {
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object primitiveValue = null;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized XmlRowValue> valueList = null;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized DateTime dateTimeValue = null;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized XmlRowValue> nestedValue = null;

    XmlRowValue() {
    }

    @XmlElement(name="value")
    @Nullable
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object getPrimitiveValue() {
        return this.primitiveValue;
    }

    @XmlElement(name="value")
    @XmlJavaTypeAdapter(value=XmlDateTimeAdapter.class)
    @Nullable
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized DateTime getDateTimeValue() {
        return this.dateTimeValue;
    }

    @XmlElement(name="array")
    @Nullable
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized XmlRowValue> getValueList() {
        return this.valueList;
    }

    @XmlElement(name="row")
    @Nullable
    @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized XmlRowValue> getNestedValue() {
        return this.nestedValue;
    }

    void setPrimitiveValue(@UnknownKeyFor @NonNull @Initialized Object primitiveValue) {
        this.primitiveValue = primitiveValue;
    }

    void setValueList(@UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized XmlRowValue> valueList) {
        this.valueList = valueList;
    }

    void setValue(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Row parent) {
        Schema schema = parent.getSchema();
        Schema.Field field = schema.getField(key);
        Schema.FieldType fieldType = field.getType();
        Schema.TypeName typeName = fieldType.getTypeName();
        switch (typeName) {
            case BOOLEAN: 
            case BYTE: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT16: 
            case INT32: 
            case INT64: 
            case STRING: {
                this.primitiveValue = parent.getValue(key);
                return;
            }
            case ARRAY: 
            case ITERABLE: {
                this.setArrayValue(key, field, parent);
                return;
            }
            case DATETIME: {
                this.setDateTimeValue(key, parent);
                return;
            }
            case ROW: {
                Optional<Row> child = Optional.ofNullable(parent.getRow(key));
                Preconditions.checkState((boolean)child.isPresent());
                this.setNestedValue(child.get());
                return;
            }
        }
        throw new IllegalArgumentException(String.format("%s at key %s is not supported", typeName.name(), key));
    }

    private void setArrayValue(@UnknownKeyFor @NonNull @Initialized String key, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Row parent) {
        Optional<Schema.FieldType> collectionFieldType = Optional.ofNullable(field.getType().getCollectionElementType());
        Preconditions.checkState((boolean)collectionFieldType.isPresent());
        Schema.TypeName collectionFieldTypeName = collectionFieldType.get().getTypeName();
        Optional<Iterable> iterable = Optional.ofNullable(parent.getIterable(key));
        Preconditions.checkState((boolean)iterable.isPresent());
        this.valueList = new ArrayList();
        Optional<ArrayList<XmlRowValue>> safeValueList = Optional.of(this.valueList);
        switch (collectionFieldTypeName) {
            case BOOLEAN: 
            case BYTE: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT16: 
            case INT32: 
            case INT64: 
            case STRING: {
                for (Object element : iterable.get()) {
                    XmlRowValue value = new XmlRowValue();
                    value.setPrimitiveValue(element);
                    safeValueList.get().add(value);
                }
                return;
            }
            case DATETIME: {
                for (Object element : iterable.get()) {
                    XmlRowValue value = new XmlRowValue();
                    value.setDateTimeValue((ReadableDateTime)((Instant)element).toDateTime());
                    safeValueList.get().add(value);
                }
                return;
            }
            case ROW: {
                for (Object value : iterable.get()) {
                    Row nestedValue = (Row)value;
                    XmlRowValue element = new XmlRowValue();
                    element.setNestedValue(nestedValue);
                    safeValueList.get().add(element);
                }
                return;
            }
        }
        throw new IllegalArgumentException(String.format("%s at key %s is not supported", collectionFieldType, key));
    }

    private void setDateTimeValue(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Row parent) {
        Optional<ReadableDateTime> value = Optional.ofNullable(parent.getDateTime(key));
        Preconditions.checkState((boolean)value.isPresent());
        this.setDateTimeValue(value.get());
    }

    private void setDateTimeValue(@UnknownKeyFor @NonNull @Initialized ReadableDateTime value) {
        this.dateTimeValue = Instant.ofEpochMilli((long)value.getMillis()).toDateTime();
    }

    private void setNestedValue(@UnknownKeyFor @NonNull @Initialized Row row) {
        Schema schema = row.getSchema();
        this.nestedValue = new HashMap();
        Optional<HashMap<String, XmlRowValue>> safeNestedValue = Optional.of(this.nestedValue);
        for (String key : schema.getFieldNames()) {
            XmlRowValue child = new XmlRowValue();
            child.setValue(key, row);
            safeNestedValue.get().put(key, child);
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlRowValue that = (XmlRowValue)o;
        Optional<Object> thatPrimitiveValue = Optional.ofNullable(that.getPrimitiveValue());
        Optional<Object> primitiveValue = Optional.ofNullable(this.getPrimitiveValue());
        Optional<DateTime> thatPrimitiveDateTime = Optional.ofNullable(that.getDateTimeValue());
        Optional<DateTime> dateTime = Optional.ofNullable(this.getDateTimeValue());
        Optional<ArrayList<XmlRowValue>> thatValueList = Optional.ofNullable(that.getValueList());
        Optional<ArrayList<XmlRowValue>> valueList = Optional.ofNullable(this.getValueList());
        Optional<HashMap<String, XmlRowValue>> thatNestedValue = Optional.ofNullable(that.getNestedValue());
        Optional<HashMap<String, XmlRowValue>> nestedValue = Optional.ofNullable(this.getNestedValue());
        return XmlRowValue.equals(primitiveValue, thatPrimitiveValue) && XmlRowValue.equals(dateTime, thatPrimitiveDateTime) && XmlRowValue.equals(valueList, thatValueList) && XmlRowValue.equals(nestedValue, thatNestedValue);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Optional<T> a, @UnknownKeyFor @NonNull @Initialized Optional<T> b) {
        if (a.isPresent() && b.isPresent()) {
            return a.get().equals(b.get());
        }
        return !a.isPresent() && !b.isPresent();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        Optional<Object> primitive = Optional.ofNullable(this.getPrimitiveValue());
        Optional<ArrayList<XmlRowValue>> list = Optional.ofNullable(this.getValueList());
        Optional<DateTime> dateTime = Optional.ofNullable(this.getDateTimeValue());
        Optional<HashMap<String, XmlRowValue>> nested = Optional.ofNullable(this.getNestedValue());
        int result = primitive.hashCode();
        result = 31 * result + list.hashCode();
        result = 31 * result + dateTime.hashCode();
        result = 31 * result + nested.hashCode();
        return result;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "XmlRowValue{primitiveValue=" + this.primitiveValue + '}';
    }
}

