/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileWriteSchemaTransformFormatProvider.class})
public class ParquetWriteSchemaTransformFormatProvider
implements FileWriteSchemaTransformFormatProvider {
    private static final @UnknownKeyFor @NonNull @Initialized String SUFFIX = String.format(".%s", "parquet");
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized GenericRecord> ERROR_FN_OUPUT_TAG = new TupleTag<GenericRecord>(){};

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "parquet";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> buildTransform(final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration, final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.schemas.Schema schema) {
        return new PTransform<PCollection<Row>, PCollectionTuple>(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                Schema avroSchema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)schema);
                AvroGenericCoder coder = AvroCoder.of((Schema)avroSchema);
                FileIO.Write write = FileIO.write().to(configuration.getFilenamePrefix()).via((FileIO.Sink)ParquetWriteSchemaTransformFormatProvider.this.buildSink(ParquetWriteSchemaTransformFormatProvider.parquetConfiguration(configuration), schema)).withSuffix(SUFFIX);
                write = FileWriteSchemaTransformFormatProviders.applyCommonFileIOWriteFeatures(write, configuration);
                PCollectionTuple parquet = (PCollectionTuple)input.apply("Row To GenericRecord", (PTransform)ParDo.of(new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq<GenericRecord>("Parquet-write-error-counter", AvroUtils.getRowToGenericRecordFunction((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)schema)), ERROR_FN_OUPUT_TAG)).withOutputTags(ERROR_FN_OUPUT_TAG, TupleTagList.of(FileWriteSchemaTransformProvider.ERROR_TAG)));
                PCollection output = (PCollection)((WriteFilesResult)parquet.get(ERROR_FN_OUPUT_TAG).setCoder((Coder)coder).apply("Write Parquet", write)).getPerDestinationOutputFilenames().apply("perDestinationOutputFilenames", (PTransform)Values.create());
                return PCollectionTuple.of(FileWriteSchemaTransformProvider.RESULT_TAG, (PCollection)output).and(FileWriteSchemaTransformProvider.ERROR_TAG, parquet.get(FileWriteSchemaTransformProvider.ERROR_TAG).setRowSchema(FileWriteSchemaTransformProvider.ERROR_SCHEMA));
            }
        };
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ParquetIO.Sink buildSink(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration.ParquetConfiguration configuration, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.schemas.Schema schema) {
        int rowGroupSize;
        ParquetIO.Sink sink = ParquetIO.sink((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)schema)).withCompressionCodec(CompressionCodecName.valueOf((String)configuration.getCompressionCodecName()));
        if (configuration.getRowGroupSize() != null && (rowGroupSize = ParquetWriteSchemaTransformFormatProvider.getRowGroupSize(configuration).intValue()) > 0) {
            sink = sink.withRowGroupSize(rowGroupSize);
        }
        return sink;
    }

    private static @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration.ParquetConfiguration parquetConfiguration(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<FileWriteSchemaTransformConfiguration.ParquetConfiguration> parquetConfiguration = Optional.ofNullable(configuration.getParquetConfiguration());
        Preconditions.checkState((boolean)parquetConfiguration.isPresent());
        return parquetConfiguration.get();
    }

    private static @UnknownKeyFor @NonNull @Initialized Integer getRowGroupSize(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration.ParquetConfiguration configuration) {
        Optional<Integer> rowGroupSize = Optional.ofNullable(configuration.getRowGroupSize());
        Preconditions.checkState((boolean)rowGroupSize.isPresent());
        return rowGroupSize.get();
    }
}

