/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.JsonPayloadSerializerProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileWriteSchemaTransformFormatProvider.class})
public class JsonWriteSchemaTransformFormatProvider
implements FileWriteSchemaTransformFormatProvider {
    final @UnknownKeyFor @NonNull @Initialized String suffix = String.format(".%s", "json");
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> ERROR_FN_OUPUT_TAG = new TupleTag<String>(){};

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "json";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> buildTransform(final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration, final @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new PTransform<PCollection<Row>, PCollectionTuple>(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                PCollectionTuple json = (PCollectionTuple)input.apply((PTransform)ParDo.of(new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq<String>("Json-write-error-counter", new RowToJsonFn(schema), ERROR_FN_OUPUT_TAG)).withOutputTags(ERROR_FN_OUPUT_TAG, TupleTagList.of(FileWriteSchemaTransformProvider.ERROR_TAG)));
                TextIO.Write write = TextIO.write().to(configuration.getFilenamePrefix()).withSuffix(JsonWriteSchemaTransformFormatProvider.this.suffix);
                write = FileWriteSchemaTransformFormatProviders.applyCommonTextIOWriteFeatures(write, configuration);
                PCollection output = (PCollection)((WriteFilesResult)json.get(ERROR_FN_OUPUT_TAG).apply("Write Json", (PTransform)write.withOutputFilenames())).getPerDestinationOutputFilenames().apply("perDestinationOutputFilenames", (PTransform)Values.create());
                return PCollectionTuple.of(FileWriteSchemaTransformProvider.RESULT_TAG, (PCollection)output).and(FileWriteSchemaTransformProvider.ERROR_TAG, json.get(FileWriteSchemaTransformProvider.ERROR_TAG).setRowSchema(FileWriteSchemaTransformProvider.ERROR_SCHEMA));
            }
        };
    }

    @UnknownKeyFor @NonNull @Initialized MapElements<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized String> mapRowsToJsonStrings(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction)new RowToJsonFn(schema));
    }

    @VisibleForTesting
    static class RowToJsonFn
    implements SerializableFunction<Row, String> {
        private final @UnknownKeyFor @NonNull @Initialized PayloadSerializer payloadSerializer;

        RowToJsonFn(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.payloadSerializer = new JsonPayloadSerializerProvider().getSerializer(schema, (Map)ImmutableMap.of());
        }

        public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            return new String(this.payloadSerializer.serialize(input), StandardCharsets.UTF_8);
        }
    }
}

