/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class FileWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<FileWriteSchemaTransformConfiguration> {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field FILE_NAME_FIELD = Schema.Field.of((String)"fileName", (Schema.FieldType)Schema.FieldType.STRING);
    public static final @UnknownKeyFor @NonNull @Initialized Schema OUTPUT_SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{FILE_NAME_FIELD});
    public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_SCHEMA = Schema.builder().addStringField("error").addNullableByteArrayField("row").build();
    private static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:schematransform:org.apache.beam:file_write:v1";
    static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";
    static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    static final @UnknownKeyFor @NonNull @Initialized String ERROR_STRING = "error";
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> RESULT_TAG = new TupleTag<String>(){};

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration> configurationClass() {
        return FileWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        return new FileWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return IDENTIFIER;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    static class FileWriteSchemaTransform
    extends SchemaTransform {
        final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration;

        FileWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
            FileWriteSchemaTransform.validateConfiguration(configuration);
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (input.getAll().isEmpty() || input.getAll().size() > 1) {
                throw new IllegalArgumentException(String.format("%s expects a single %s tagged PCollection<Row> input", FileWriteSchemaTransform.class.getName(), FileWriteSchemaTransformProvider.INPUT_TAG));
            }
            PCollection rowInput = input.get(FileWriteSchemaTransformProvider.INPUT_TAG);
            PTransform<PCollection<Row>, PCollectionTuple> transform = this.getProvider().buildTransform(this.configuration, rowInput.getSchema());
            PCollectionTuple files = (PCollectionTuple)rowInput.apply("Write Rows", transform);
            PCollection output = ((PCollection)files.get(RESULT_TAG).apply("Filenames to Rows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)name -> Row.withSchema((Schema)OUTPUT_SCHEMA).withFieldValue(FILE_NAME_FIELD.getName(), name).build()))).setRowSchema(OUTPUT_SCHEMA);
            if (files.has(ERROR_TAG)) {
                return PCollectionRowTuple.of((String)FileWriteSchemaTransformProvider.OUTPUT_TAG, (PCollection)output).and(FileWriteSchemaTransformProvider.ERROR_STRING, files.get(ERROR_TAG));
            }
            return PCollectionRowTuple.of((String)FileWriteSchemaTransformProvider.OUTPUT_TAG, (PCollection)output);
        }

        @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformFormatProvider getProvider() {
            Map<String, FileWriteSchemaTransformFormatProvider> providers = FileWriteSchemaTransformFormatProviders.loadProviders();
            if (!providers.containsKey(this.configuration.getFormat())) {
                throw new IllegalArgumentException(String.format("%s is not a supported format. See %s for a list of supported formats.", this.configuration.getFormat(), FileWriteSchemaTransformFormatProviders.class.getName()));
            }
            Optional<FileWriteSchemaTransformFormatProvider> provider = Optional.ofNullable(providers.get(this.configuration.getFormat()));
            Preconditions.checkState((boolean)provider.isPresent());
            return provider.get();
        }

        static void validateConfiguration(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
            String format = configuration.getFormat();
            if (configuration.getCsvConfiguration() != null && !format.equals("csv")) {
                throw new IllegalArgumentException(String.format("configuration with %s is not compatible with a %s format", FileWriteSchemaTransformConfiguration.CsvConfiguration.class.getName(), format));
            }
            if (configuration.getParquetConfiguration() != null && !format.equals("parquet")) {
                throw new IllegalArgumentException(String.format("configuration with %s is not compatible with a %s format", FileWriteSchemaTransformConfiguration.ParquetConfiguration.class.getName(), format));
            }
            if (configuration.getXmlConfiguration() != null && !format.equals("xml")) {
                throw new IllegalArgumentException(String.format("configuration with %s is not compatible with a %s format", FileWriteSchemaTransformConfiguration.XmlConfiguration.class.getName(), format));
            }
            if (format.equals("avro") && !Strings.isNullOrEmpty((String)configuration.getCompression())) {
                throw new IllegalArgumentException("configuration with compression is not compatible with AvroIO");
            }
            if (format.equals("parquet") && !Strings.isNullOrEmpty((String)configuration.getCompression())) {
                throw new IllegalArgumentException("configuration with compression is not compatible with ParquetIO");
            }
        }
    }
}

