/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class FileWriteSchemaTransformFormatProviders {
    static final @UnknownKeyFor @NonNull @Initialized String AVRO = "avro";
    static final @UnknownKeyFor @NonNull @Initialized String CSV = "csv";
    static final @UnknownKeyFor @NonNull @Initialized String JSON = "json";
    static final @UnknownKeyFor @NonNull @Initialized String PARQUET = "parquet";
    static final @UnknownKeyFor @NonNull @Initialized String XML = "xml";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileWriteSchemaTransformFormatProviders.class);

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformFormatProvider> loadProviders() {
        return Providers.loadProviders(FileWriteSchemaTransformFormatProvider.class);
    }

    static @UnknownKeyFor @NonNull @Initialized MapElements<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized GenericRecord> mapRowsToGenericRecords(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.schemas.Schema beamSchema) {
        return MapElements.into((TypeDescriptor)TypeDescriptor.of(GenericRecord.class)).via(AvroUtils.getRowToGenericRecordFunction((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)beamSchema)));
    }

    static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileIO.Write<@UnknownKeyFor @Nullable @Initialized Void, T> applyCommonFileIOWriteFeatures(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized FileIO.Write<@UnknownKeyFor @Nullable @Initialized Void, T> write, @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        int numShards;
        if (!Strings.isNullOrEmpty((String)configuration.getFilenameSuffix())) {
            write = write.withSuffix(FileWriteSchemaTransformFormatProviders.getFilenameSuffix(configuration));
        }
        if (configuration.getNumShards() != null && (numShards = FileWriteSchemaTransformFormatProviders.getNumShards(configuration).intValue()) > 0) {
            write = write.withNumShards(numShards);
        }
        if (!Strings.isNullOrEmpty((String)configuration.getCompression())) {
            write = write.withCompression(FileWriteSchemaTransformFormatProviders.getCompression(configuration));
        }
        return write;
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TextIO.Write applyCommonTextIOWriteFeatures(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TextIO.Write write, @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        int numShards;
        write = write.to(configuration.getFilenamePrefix());
        if (!Strings.isNullOrEmpty((String)configuration.getFilenameSuffix())) {
            write = write.withSuffix(FileWriteSchemaTransformFormatProviders.getFilenameSuffix(configuration));
        }
        if (!Strings.isNullOrEmpty((String)configuration.getCompression())) {
            write = write.withCompression(FileWriteSchemaTransformFormatProviders.getCompression(configuration));
        }
        if (configuration.getNumShards() != null && (numShards = FileWriteSchemaTransformFormatProviders.getNumShards(configuration).intValue()) > 0) {
            write = write.withNumShards(numShards);
        }
        if (!Strings.isNullOrEmpty((String)configuration.getShardNameTemplate())) {
            write = write.withShardNameTemplate(FileWriteSchemaTransformFormatProviders.getShardNameTemplate(configuration));
        }
        return write;
    }

    static @UnknownKeyFor @NonNull @Initialized Compression getCompression(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<String> compression = Optional.ofNullable(configuration.getCompression());
        Preconditions.checkState((boolean)compression.isPresent());
        return Compression.valueOf((String)compression.get());
    }

    static @UnknownKeyFor @NonNull @Initialized String getFilenameSuffix(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<String> suffix = Optional.ofNullable(configuration.getFilenameSuffix());
        Preconditions.checkState((boolean)suffix.isPresent());
        return suffix.get();
    }

    static @UnknownKeyFor @NonNull @Initialized Integer getNumShards(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<Integer> numShards = Optional.ofNullable(configuration.getNumShards());
        Preconditions.checkState((boolean)numShards.isPresent());
        return numShards.get();
    }

    static @UnknownKeyFor @NonNull @Initialized String getShardNameTemplate(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<String> shardNameTemplate = Optional.ofNullable(configuration.getShardNameTemplate());
        Preconditions.checkState((boolean)shardNameTemplate.isPresent());
        return shardNameTemplate.get();
    }

    static class BeamRowMapperWithDlq<@UnknownKeyFor OutputT>
    extends DoFn<Row, OutputT> {
        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, OutputT> mapFn;
        private @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
        private @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag;
        private @UnknownKeyFor @NonNull @Initialized long errorsInBundle = 0L;

        public BeamRowMapperWithDlq(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, OutputT> mapFn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> outputTag) {
            this.errorCounter = Metrics.counter(FileWriteSchemaTransformFormatProvider.class, (String)name);
            this.mapFn = mapFn;
            this.outputTag = outputTag;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            try {
                receiver.get(this.outputTag).output(this.mapFn.apply((Object)row));
            }
            catch (Exception e) {
                ++this.errorsInBundle;
                LOG.warn("Error while parsing input element", (Throwable)e);
                receiver.get(FileWriteSchemaTransformProvider.ERROR_TAG).output((Object)Row.withSchema((org.apache.beam.sdk.schemas.Schema)FileWriteSchemaTransformProvider.ERROR_SCHEMA).addValues(new Object[]{e.toString(), row.toString().getBytes(StandardCharsets.UTF_8)}).build());
            }
        }

        @DoFn.FinishBundle
        public void finish() {
            this.errorCounter.inc(this.errorsInBundle);
            this.errorsInBundle = 0L;
        }
    }
}

