/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.value.AutoValue;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.fileschematransform.AutoValue_FileReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformFormatProvider;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class FileReadSchemaTransformConfiguration {
    public static final @UnknownKeyFor @NonNull @Initialized Set<@KeyFor(value={"org.apache.beam.sdk.schemas.io.Providers.loadProviders(org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformFormatProvider.class)"}) @NonNull @Initialized String> VALID_PROVIDERS = Providers.loadProviders(FileReadSchemaTransformFormatProvider.class).keySet();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_FileReadSchemaTransformConfiguration.Builder();
    }

    @SchemaFieldDescription(value="The format of the file(s) to read. Possible values are \"lines\", \"avro\", \"parquet\", \"json\".")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

    @SchemaFieldDescription(value="The filepattern used to match and read files. May instead use an input PCollection<Row> of filepatterns. To do so, each Row must have a \"filepattern\" String field containing the filepattern.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getFilepattern();

    public @UnknownKeyFor @NonNull @Initialized String getSafeFilepattern() {
        Optional<String> filepattern = Optional.ofNullable(this.getFilepattern());
        Preconditions.checkState((filepattern.isPresent() && !filepattern.get().isEmpty() ? 1 : 0) != 0, (Object)"Unexpected null or empty filepattern");
        return filepattern.get();
    }

    @SchemaFieldDescription(value="The schema used by sources to deserialize data and create Beam Rows. May provide either a String representation of the schema or a single path to a file that contains the schema.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getSchema();

    public @UnknownKeyFor @NonNull @Initialized String getSafeSchema() {
        Optional<String> schema = Optional.ofNullable(this.getSchema());
        Preconditions.checkState((schema.isPresent() && !schema.get().isEmpty() ? 1 : 0) != 0, (Object)"Unexpected null or empty schema");
        return schema.get();
    }

    @SchemaFieldDescription(value="The time, in milliseconds, to wait before polling for new files. This will set the pipeline to be a streaming pipeline that continuously watches for new files.Note: This only polls for new files. New updates to an existing file will not be watched for.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getPollIntervalMillis();

    @SchemaFieldDescription(value="If no new files are found after this many seconds, this transform will cease to watch for new files. The default is to never terminate. To set this parameter, a poll interval must also be provided.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getTerminateAfterSecondsSinceNewOutput();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setPollIntervalMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setTerminateAfterSecondsSinceNewOutput(@UnknownKeyFor @NonNull @Initialized Long var1);

        abstract @UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration autoBuild();

        public @UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration build() {
            FileReadSchemaTransformConfiguration config = this.autoBuild();
            Preconditions.checkArgument((boolean)VALID_PROVIDERS.contains(config.getFormat()), (Object)String.format("Received invalid file format: [%s]. Please specify one of: %s.", config.getFormat(), VALID_PROVIDERS));
            if (!config.getFormat().equals("line")) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getSchema()) ? 1 : 0) != 0, (Object)String.format("A schema must be specified when reading files with %s formats. You may provide a schema string or a path to a file containing the schema.", Sets.difference(VALID_PROVIDERS, (Set)Sets.newHashSet((Object[])new String[]{"line"}))));
            }
            Long terminateAfterSecondsSinceNewOutput = config.getTerminateAfterSecondsSinceNewOutput();
            Long pollIntervalMillis = config.getPollIntervalMillis();
            if (terminateAfterSecondsSinceNewOutput != null && terminateAfterSecondsSinceNewOutput > 0L) {
                Preconditions.checkArgument((pollIntervalMillis != null && pollIntervalMillis > 0L ? 1 : 0) != 0, (Object)"Found positive value for terminateAfterSecondsSinceNewOutput but non-positivevalue for pollIntervalMillis. Please set pollIntervalMillis as well to enablewatching for new files.");
            }
            return config;
        }
    }
}

