/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_FileWriteSchemaTransformConfiguration_XmlConfiguration
extends FileWriteSchemaTransformConfiguration.XmlConfiguration {
    private final String rootElement;
    private final String charset;

    private AutoValue_FileWriteSchemaTransformConfiguration_XmlConfiguration(String rootElement, String charset) {
        this.rootElement = rootElement;
        this.charset = charset;
    }

    @Override
    @SchemaFieldDescription(value="Sets the enclosing root element for the generated XML files.")
    public String getRootElement() {
        return this.rootElement;
    }

    @Override
    @SchemaFieldDescription(value="The charset used to write the file. Defaults to UTF_8")
    public String getCharset() {
        return this.charset;
    }

    public String toString() {
        return "XmlConfiguration{rootElement=" + this.rootElement + ", charset=" + this.charset + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileWriteSchemaTransformConfiguration.XmlConfiguration) {
            FileWriteSchemaTransformConfiguration.XmlConfiguration that = (FileWriteSchemaTransformConfiguration.XmlConfiguration)o;
            return this.rootElement.equals(that.getRootElement()) && this.charset.equals(that.getCharset());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.rootElement.hashCode();
        h$ *= 1000003;
        return h$ ^= this.charset.hashCode();
    }

    static final class Builder
    extends FileWriteSchemaTransformConfiguration.XmlConfiguration.Builder {
        private String rootElement;
        private String charset;

        Builder() {
        }

        @Override
        public FileWriteSchemaTransformConfiguration.XmlConfiguration.Builder setRootElement(String rootElement) {
            if (rootElement == null) {
                throw new NullPointerException("Null rootElement");
            }
            this.rootElement = rootElement;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.XmlConfiguration.Builder setCharset(String charset) {
            if (charset == null) {
                throw new NullPointerException("Null charset");
            }
            this.charset = charset;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.XmlConfiguration build() {
            if (this.rootElement == null || this.charset == null) {
                StringBuilder missing = new StringBuilder();
                if (this.rootElement == null) {
                    missing.append(" rootElement");
                }
                if (this.charset == null) {
                    missing.append(" charset");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FileWriteSchemaTransformConfiguration_XmlConfiguration(this.rootElement, this.charset);
        }
    }
}

