/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_FileWriteSchemaTransformConfiguration_ParquetConfiguration
extends FileWriteSchemaTransformConfiguration.ParquetConfiguration {
    private final String compressionCodecName;
    private final Integer rowGroupSize;

    private AutoValue_FileWriteSchemaTransformConfiguration_ParquetConfiguration(String compressionCodecName, @Nullable Integer rowGroupSize) {
        this.compressionCodecName = compressionCodecName;
        this.rowGroupSize = rowGroupSize;
    }

    @Override
    @SchemaFieldDescription(value="Specifies compression codec. Valid values are: \"GZIP\", \"LZO\", \"SNAPPY\", \"UNCOMPRESSED\"")
    public String getCompressionCodecName() {
        return this.compressionCodecName;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specify row-group size; if not set or zero, a default is used by the underlying writer.")
    public Integer getRowGroupSize() {
        return this.rowGroupSize;
    }

    public String toString() {
        return "ParquetConfiguration{compressionCodecName=" + this.compressionCodecName + ", rowGroupSize=" + this.rowGroupSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileWriteSchemaTransformConfiguration.ParquetConfiguration) {
            FileWriteSchemaTransformConfiguration.ParquetConfiguration that = (FileWriteSchemaTransformConfiguration.ParquetConfiguration)o;
            return this.compressionCodecName.equals(that.getCompressionCodecName()) && (this.rowGroupSize == null ? that.getRowGroupSize() == null : this.rowGroupSize.equals(that.getRowGroupSize()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.compressionCodecName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.rowGroupSize == null ? 0 : this.rowGroupSize.hashCode();
    }

    static final class Builder
    extends FileWriteSchemaTransformConfiguration.ParquetConfiguration.Builder {
        private String compressionCodecName;
        private Integer rowGroupSize;

        Builder() {
        }

        @Override
        public FileWriteSchemaTransformConfiguration.ParquetConfiguration.Builder setCompressionCodecName(String compressionCodecName) {
            if (compressionCodecName == null) {
                throw new NullPointerException("Null compressionCodecName");
            }
            this.compressionCodecName = compressionCodecName;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.ParquetConfiguration.Builder setRowGroupSize(Integer rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.ParquetConfiguration build() {
            if (this.compressionCodecName == null) {
                String missing = " compressionCodecName";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FileWriteSchemaTransformConfiguration_ParquetConfiguration(this.compressionCodecName, this.rowGroupSize);
        }
    }
}

