/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.io.fileschematransform.XmlRowAdapter;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=JUnit4.class)
public class XmlRowAdapterTest {
    @Test
    public void allPrimitiveDataTypes() throws XPathExpressionException, JAXBException, IOException, SAXException, ParserConfigurationException {
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.allPrimitiveDataTypesRows) {
            NodeList entries = this.xmlDocumentEntries(row);
            Assert.assertEquals((long)SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA.getFieldNames().size(), (long)entries.getLength());
            Map<String, Node> actualMap = XmlRowAdapterTest.keyValues("allPrimitiveDataTypes", entries);
            Assert.assertEquals(new HashSet(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA.getFieldNames()), actualMap.keySet());
            for (Map.Entry<String, Node> actualKV : actualMap.entrySet()) {
                String key = actualKV.getKey();
                Node node = actualKV.getValue();
                String actual = node.getTextContent();
                Optional<Object> safeExpected = Optional.ofNullable(row.getValue(key));
                Assert.assertTrue((boolean)safeExpected.isPresent());
                String expected = safeExpected.get().toString();
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void nullableAllPrimitiveDataTypes() throws XPathExpressionException, JAXBException, IOException, SAXException, ParserConfigurationException {
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.nullableAllPrimitiveDataTypesRows) {
            NodeList entries = this.xmlDocumentEntries(row);
            Assert.assertEquals((long)SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA.getFieldNames().size(), (long)entries.getLength());
            Map<String, Node> actualMap = XmlRowAdapterTest.keyValues("nullableAllPrimitiveDataTypes", entries);
            Assert.assertEquals(new HashSet(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA.getFieldNames()), actualMap.keySet());
            for (Map.Entry<String, Node> actualKV : actualMap.entrySet()) {
                String key = actualKV.getKey();
                Node node = actualKV.getValue();
                String actual = node.getTextContent();
                String expected = "";
                Optional<Object> safeExpected = Optional.ofNullable(row.getValue(key));
                if (safeExpected.isPresent()) {
                    expected = safeExpected.get().toString();
                }
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
    }

    @Test
    public void timeContaining() throws XPathExpressionException, JAXBException, IOException, ParserConfigurationException, SAXException {
        String instant = "instant";
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        String instantList = "instantList";
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows) {
            Optional<SchemaAwareJavaBeans.TimeContaining> safeExpectedTimeContaining = Optional.ofNullable((SchemaAwareJavaBeans.TimeContaining)SchemaAwareJavaBeans.timeContainingFromRowFn().apply((Object)row));
            Assert.assertTrue((boolean)safeExpectedTimeContaining.isPresent());
            SchemaAwareJavaBeans.TimeContaining expectedTimeContaining = safeExpectedTimeContaining.get();
            NodeList entries = this.xmlDocumentEntries(row);
            Assert.assertEquals((long)SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA.getFieldNames().size(), (long)entries.getLength());
            Map<String, Node> actualMap = XmlRowAdapterTest.keyValues("timeContaining", entries);
            Assert.assertEquals(new HashSet(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA.getFieldNames()), actualMap.keySet());
            Node actualInstantNode = actualMap.get(instant);
            String actual = actualInstantNode.getTextContent();
            String expected = formatter.print((ReadableInstant)expectedTimeContaining.getInstant().toDateTime());
            Assert.assertEquals((Object)expected, (Object)actual);
            List actualInstantList = XmlRowAdapterTest.toStringList(actualMap.get(instantList).getChildNodes()).stream().sorted().collect(Collectors.toList());
            List expectedInstantList = expectedTimeContaining.getInstantList().stream().map(Instant::toDateTime).map(arg_0 -> ((DateTimeFormatter)formatter).print(arg_0)).sorted().collect(Collectors.toList());
            Assert.assertEquals(expectedInstantList, actualInstantList);
        }
    }

    private static List<String> toStringList(NodeList nodes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            result.add(node.getTextContent());
        }
        return result;
    }

    private static Map<String, Node> keyValues(String testName, NodeList entries) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        for (int i = 0; i < entries.getLength(); ++i) {
            NodeList kv = entries.item(i).getChildNodes();
            Assert.assertEquals((String)testName, (long)2L, (long)kv.getLength());
            String key = kv.item(0).getTextContent();
            Node value = kv.item(1);
            result.put(key, value);
        }
        return result;
    }

    private NodeList xmlDocumentEntries(Row row) throws JAXBException, IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlRowAdapter.class});
        Marshaller marshaller = context.createMarshaller();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        XPath entryPath = XPathFactory.newInstance().newXPath();
        XPathExpression entryPathExpression = entryPath.compile("/row/data/entry");
        XmlRowAdapter adapter = new XmlRowAdapter();
        adapter.wrapRow(row);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)adapter, (Writer)writer);
        String content = writer.toString();
        Document xmlDocument = documentBuilder.parse(new InputSource(new StringReader(content)));
        return (NodeList)entryPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
    }
}

