/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.JsonWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.JsonPayloadSerializerProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JsonWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    private static final TupleTag<String> OUTPUT_TAG = JsonWriteSchemaTransformFormatProvider.ERROR_FN_OUPUT_TAG;
    private static final TupleTag<Row> ERROR_TAG = FileWriteSchemaTransformProvider.ERROR_TAG;
    private static final Schema BEAM_SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING)});
    private static final Schema BEAM_SCHEMA_DLQ = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"error", (Schema.FieldType)Schema.FieldType.INT32)});
    private static final Schema ERROR_SCHEMA = FileWriteSchemaTransformProvider.ERROR_SCHEMA;
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"a").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"b").build(), Row.withSchema((Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"c").build());

    @Override
    protected String getFormat() {
        return "json";
    }

    @Override
    protected String getFilenamePrefix() {
        return "/out";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, Schema beamSchema) {
        PCollection actual = (PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(folder + "*"));
        PayloadSerializer payloadSerializer = new JsonPayloadSerializerProvider().getSerializer(beamSchema, (Map)ImmutableMap.of());
        PAssert.that((PCollection)actual).containsInAnyOrder((Iterable)rows.stream().map(row -> new String(payloadSerializer.serialize(row), StandardCharsets.UTF_8)).collect(Collectors.toList()));
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return this.defaultConfiguration(folder);
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$ParquetConfiguration is not compatible with a json format");
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$XmlConfiguration is not compatible with a json format");
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$CsvConfiguration is not compatible with a json format");
    }

    @Test
    public void testJsonErrorCounterSuccess() {
        JsonWriteSchemaTransformFormatProvider.RowToJsonFn mapFn = new JsonWriteSchemaTransformFormatProvider.RowToJsonFn(BEAM_SCHEMA);
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Json-write-error-counter", (SerializableFunction)mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PCollection count = (PCollection)output.get(OUTPUT_TAG).apply(Count.globally());
        PAssert.that((PCollection)count).containsInAnyOrder(Collections.singleton(3L));
        this.writePipeline.run().waitUntilFinish();
    }

    @Test
    public void testJsonErrorCounterFailure() {
        JsonWriteSchemaTransformFormatProvider.RowToJsonFn mapFn = new JsonWriteSchemaTransformFormatProvider.RowToJsonFn(BEAM_SCHEMA_DLQ);
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Json-write-error-counter", (SerializableFunction)mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PCollection count = (PCollection)output.get(ERROR_TAG).apply(Count.globally());
        PAssert.that((PCollection)count).containsInAnyOrder(Collections.singletonList(3L));
        this.writePipeline.run().waitUntilFinish();
    }
}

