/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.fileschematransform.AvroWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AvroWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    private static final TupleTag<GenericRecord> OUTPUT_TAG = AvroWriteSchemaTransformFormatProvider.ERROR_FN_OUPUT_TAG;
    private static final TupleTag<Row> ERROR_TAG = FileWriteSchemaTransformProvider.ERROR_TAG;
    private static final org.apache.beam.sdk.schemas.Schema BEAM_SCHEMA = org.apache.beam.sdk.schemas.Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING)});
    private static final org.apache.beam.sdk.schemas.Schema BEAM_SCHEMA_DLQ = org.apache.beam.sdk.schemas.Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"error", (Schema.FieldType)Schema.FieldType.INT32)});
    private static final org.apache.beam.sdk.schemas.Schema ERROR_SCHEMA = FileWriteSchemaTransformProvider.ERROR_SCHEMA;
    private static final Schema AVRO_SCHEMA = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA);
    private static final AvroCoder<GenericRecord> CODER = AvroCoder.of((Schema)AVRO_SCHEMA);
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"a").build(), Row.withSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"b").build(), Row.withSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA).withFieldValue("name", (Object)"c").build());

    @Override
    protected String getFormat() {
        return "avro";
    }

    @Override
    protected String getFilenamePrefix() {
        return "/";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, org.apache.beam.sdk.schemas.Schema beamSchema) {
        Schema avroSchema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)beamSchema);
        AvroGenericCoder coder = AvroCoder.of((Schema)avroSchema);
        List expected = rows.stream().map(arg_0 -> ((SerializableFunction)AvroUtils.getRowToGenericRecordFunction((Schema)avroSchema)).apply(arg_0)).collect(Collectors.toList());
        PCollection actual = ((PCollection)this.readPipeline.apply((PTransform)AvroIO.readGenericRecords((Schema)avroSchema).from(folder + this.getFilenamePrefix() + "*"))).setCoder((Coder)coder);
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return this.defaultConfiguration(folder);
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.of("configuration with compression is not compatible with AvroIO");
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$ParquetConfiguration is not compatible with a avro format");
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$XmlConfiguration is not compatible with a avro format");
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$CsvConfiguration is not compatible with a avro format");
    }

    @Test
    public void testAvroErrorCounterSuccess() {
        SerializableFunction mapFn = AvroUtils.getRowToGenericRecordFunction((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA));
        List<GenericRecord> records = Arrays.asList(new GenericRecordBuilder(AVRO_SCHEMA).set("name", (Object)"a").build(), new GenericRecordBuilder(AVRO_SCHEMA).set("name", (Object)"b").build(), new GenericRecordBuilder(AVRO_SCHEMA).set("name", (Object)"c").build());
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Avro-write-error-counter", mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(OUTPUT_TAG).setCoder(CODER);
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PAssert.that((PCollection)output.get(OUTPUT_TAG)).containsInAnyOrder(records);
        this.writePipeline.run().waitUntilFinish();
    }

    @Test
    public void testAvroErrorCounterFailure() {
        SerializableFunction mapFn = AvroUtils.getRowToGenericRecordFunction((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)BEAM_SCHEMA_DLQ));
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(ROWS));
        PCollectionTuple output = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq("Avro-write-error-counter", mapFn, OUTPUT_TAG)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
        output.get(OUTPUT_TAG).setCoder(CODER);
        output.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA);
        PCollection count = (PCollection)output.get(ERROR_TAG).apply(Count.globally());
        PAssert.that((PCollection)count).containsInAnyOrder(Collections.singletonList(3L));
        this.writePipeline.run().waitUntilFinish();
    }
}

