/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.io.fileschematransform.XmlRowAdapter;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileWriteSchemaTransformFormatProvider.class})
public class XmlWriteSchemaTransformFormatProvider
implements FileWriteSchemaTransformFormatProvider {
    private static final @UnknownKeyFor @NonNull @Initialized String SUFFIX = String.format(".%s", "xml");
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized XmlRowAdapter> ERROR_FN_OUPUT_TAG = new TupleTag<XmlRowAdapter>(){};

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "xml";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> buildTransform(final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new PTransform<PCollection<Row>, PCollectionTuple>(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                PCollectionTuple xml = (PCollectionTuple)input.apply("Row to XML", (PTransform)ParDo.of(new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq<XmlRowAdapter>("Xml-write-error-counter", new RowToXmlFn(), ERROR_FN_OUPUT_TAG)).withOutputTags(ERROR_FN_OUPUT_TAG, TupleTagList.of(FileWriteSchemaTransformProvider.ERROR_TAG)));
                FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfig = XmlWriteSchemaTransformFormatProvider.xmlConfiguration(configuration);
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)xmlConfig.getCharset()) ? 1 : 0) != 0, (Object)"charset must be specified");
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)xmlConfig.getRootElement()) ? 1 : 0) != 0, (Object)"rootElement must be specified");
                Charset charset = Charset.forName(xmlConfig.getCharset());
                XmlIO.Sink sink = XmlIO.sink(XmlRowAdapter.class).withCharset(charset).withRootElement(xmlConfig.getRootElement());
                FileIO.Write write = FileIO.write().to(configuration.getFilenamePrefix()).via((FileIO.Sink)sink).withSuffix(SUFFIX);
                write = FileWriteSchemaTransformFormatProviders.applyCommonFileIOWriteFeatures(write, configuration);
                PCollection output = (PCollection)((WriteFilesResult)xml.get(ERROR_FN_OUPUT_TAG).apply("Write XML", write)).getPerDestinationOutputFilenames().apply("perDestinationOutputFilenames", (PTransform)Values.create());
                return PCollectionTuple.of(FileWriteSchemaTransformProvider.RESULT_TAG, (PCollection)output).and(FileWriteSchemaTransformProvider.ERROR_TAG, xml.get(FileWriteSchemaTransformProvider.ERROR_TAG).setRowSchema(FileWriteSchemaTransformProvider.ERROR_SCHEMA));
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfiguration(@UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration) {
        Optional<FileWriteSchemaTransformConfiguration.XmlConfiguration> result = Optional.ofNullable(configuration.getXmlConfiguration());
        Preconditions.checkState((boolean)result.isPresent());
        return result.get();
    }

    static class RowToXmlFn
    implements SerializableFunction<Row, XmlRowAdapter> {
        RowToXmlFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized XmlRowAdapter apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            XmlRowAdapter result = new XmlRowAdapter();
            result.wrapRow(input);
            return result;
        }
    }
}

