/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class FileReadSchemaTransformProvider
extends TypedSchemaTransformProvider<FileReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileReadSchemaTransformProvider.class);
    private static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:schematransform:org.apache.beam:file_read:v1";
    static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";
    static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "output";
    static final @UnknownKeyFor @NonNull @Initialized String FILEPATTERN_ROW_FIELD_NAME = "filepattern";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration> configurationClass() {
        return FileReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration configuration) {
        return new FileReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return IDENTIFIER;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    @VisibleForTesting
    static class FileReadSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration configuration;
        private @UnknownKeyFor @NonNull @Initialized boolean useInputPCollection;

        FileReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
            this.useInputPCollection = Strings.isNullOrEmpty((String)configuration.getFilepattern());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            PCollection files;
            Preconditions.checkArgument((boolean)(input.getAll().isEmpty() ^ Strings.isNullOrEmpty((String)this.configuration.getFilepattern())), (Object)"Either an input PCollection of file patterns or the filepattern parameter must be set,but not both.");
            String schema = this.configuration.getSchema();
            if (!Strings.isNullOrEmpty((String)schema)) {
                schema = this.resolveSchemaStringOrFilePath(this.configuration.getSafeSchema());
                this.configuration = this.configuration.toBuilder().setSchema(schema).build();
            }
            if (this.useInputPCollection) {
                files = (PCollection)((PCollection)((WithFailures.Result)input.get(FileReadSchemaTransformProvider.INPUT_TAG).apply("Get filepatterns", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> Objects.requireNonNull(row.getString(FileReadSchemaTransformProvider.FILEPATTERN_ROW_FIELD_NAME))).exceptionsInto(TypeDescriptors.nulls()).exceptionsVia((ProcessFunction & Serializable)exceptionElement -> {
                    String faultyFilepattern = Optional.ofNullable(((Row)exceptionElement.element()).getString(FileReadSchemaTransformProvider.FILEPATTERN_ROW_FIELD_NAME)).orElse("[null filepattern]");
                    LOG.warn("Could not acquire a faulty filepattern: {}. This will be skipped.", (Object)faultyFilepattern);
                    return null;
                }))).output()).apply("Match files", (PTransform)((FileIO.MatchAll)this.buildMatchTransform()));
            } else {
                Pipeline p = input.getPipeline();
                files = (PCollection)p.apply((PTransform)((FileIO.Match)this.buildMatchTransform()));
            }
            PCollection output = (PCollection)((PCollection)files.apply((PTransform)FileIO.readMatches())).apply("Read files", this.getProvider().buildTransform(this.configuration));
            return PCollectionRowTuple.of((String)FileReadSchemaTransformProvider.OUTPUT_TAG, (PCollection)output);
        }

        @VisibleForTesting
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata>> buildMatchTransform() {
            FileIO.MatchAll matchTransform = this.useInputPCollection ? FileIO.matchAll() : FileIO.match().filepattern(this.configuration.getSafeFilepattern());
            Long terminateAfterSeconds = this.configuration.getTerminateAfterSecondsSinceNewOutput();
            Long pollIntervalMillis = this.configuration.getPollIntervalMillis();
            if (pollIntervalMillis != null && pollIntervalMillis > 0L) {
                Duration pollDuration = Duration.millis((long)pollIntervalMillis);
                Watch.Growth.Never terminationCondition = terminateAfterSeconds != null && terminateAfterSeconds > 0L ? Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardSeconds((long)terminateAfterSeconds)) : Watch.Growth.never();
                matchTransform = this.useInputPCollection ? FileIO.matchAll().continuously(pollDuration, (Watch.Growth.TerminationCondition)terminationCondition) : FileIO.match().filepattern(this.configuration.getSafeFilepattern()).continuously(pollDuration, (Watch.Growth.TerminationCondition)terminationCondition);
            }
            return matchTransform;
        }

        private @UnknownKeyFor @NonNull @Initialized String resolveSchemaStringOrFilePath(@UnknownKeyFor @NonNull @Initialized String schema) {
            try {
                MatchResult result;
                try {
                    LOG.info("Attempting to locate input schema as a file path.");
                    result = FileSystems.match((String)schema);
                    Preconditions.checkArgument((result.status() == MatchResult.Status.OK ? 1 : 0) != 0);
                }
                catch (IllegalArgumentException e) {
                    LOG.info("Input schema is not a valid file path. Will attempt to use it as a schema string.");
                    return schema;
                }
                Preconditions.checkArgument((!result.metadata().isEmpty() ? 1 : 0) != 0, (Object)"Failed to match any files for the input schema file path.");
                List resource = result.metadata().stream().map(MatchResult.Metadata::resourceId).collect(Collectors.toList());
                Preconditions.checkArgument((resource.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly 1 schema file, but got " + resource.size() + " files."));
                ReadableByteChannel byteChannel = FileSystems.open((ResourceId)((ResourceId)resource.get(0)));
                Reader reader = Channels.newReader(byteChannel, StandardCharsets.UTF_8.name());
                return CharStreams.toString((Readable)reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Error when parsing input schema file: ", e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized FileReadSchemaTransformFormatProvider getProvider() {
            String format = this.configuration.getFormat();
            Map providers = Providers.loadProviders(FileReadSchemaTransformFormatProvider.class);
            Preconditions.checkArgument((boolean)providers.containsKey(format), (Object)String.format("Received unsupported file format: %s. Supported formats are %s", format, providers.keySet()));
            Optional<FileReadSchemaTransformFormatProvider> provider = Optional.ofNullable((FileReadSchemaTransformFormatProvider)providers.get(format));
            Preconditions.checkState((boolean)provider.isPresent());
            return provider.get();
        }
    }
}

