/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import com.google.auto.service.AutoService;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProvider;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviders;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={FileWriteSchemaTransformFormatProvider.class})
public class AvroWriteSchemaTransformFormatProvider
implements FileWriteSchemaTransformFormatProvider {
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized GenericRecord> ERROR_FN_OUPUT_TAG = new TupleTag<GenericRecord>(){};

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "avro";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> buildTransform(final @UnknownKeyFor @NonNull @Initialized FileWriteSchemaTransformConfiguration configuration, final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.schemas.Schema schema) {
        return new PTransform<PCollection<Row>, PCollectionTuple>(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                int numShards;
                Schema avroSchema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)schema);
                AvroGenericCoder coder = AvroCoder.of((Schema)avroSchema);
                PCollectionTuple tuple = (PCollectionTuple)input.apply("Row To Avro Generic Record", (PTransform)ParDo.of(new FileWriteSchemaTransformFormatProviders.BeamRowMapperWithDlq<GenericRecord>("Avro-write-error-counter", AvroUtils.getRowToGenericRecordFunction((Schema)AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)schema)), ERROR_FN_OUPUT_TAG)).withOutputTags(ERROR_FN_OUPUT_TAG, TupleTagList.of(FileWriteSchemaTransformProvider.ERROR_TAG)));
                PCollection avro = tuple.get(ERROR_FN_OUPUT_TAG).setCoder((Coder)coder);
                AvroIO.Write write = AvroIO.writeGenericRecords((Schema)avroSchema).to(configuration.getFilenamePrefix());
                if (configuration.getNumShards() != null && (numShards = FileWriteSchemaTransformFormatProviders.getNumShards(configuration).intValue()) > 0) {
                    write = write.withNumShards(numShards);
                }
                if (!Strings.isNullOrEmpty((String)configuration.getShardNameTemplate())) {
                    write = write.withShardNameTemplate(FileWriteSchemaTransformFormatProviders.getShardNameTemplate(configuration));
                }
                PCollection output = (PCollection)((WriteFilesResult)avro.apply("Write Avro", (PTransform)write.withOutputFilenames())).getPerDestinationOutputFilenames().apply("perDestinationOutputFilenames", (PTransform)Values.create());
                return PCollectionTuple.of(FileWriteSchemaTransformProvider.RESULT_TAG, (PCollection)output).and(FileWriteSchemaTransformProvider.ERROR_TAG, tuple.get(FileWriteSchemaTransformProvider.ERROR_TAG).setRowSchema(FileWriteSchemaTransformProvider.ERROR_SCHEMA));
            }
        };
    }
}

