/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_FileWriteSchemaTransformConfiguration
extends FileWriteSchemaTransformConfiguration {
    private final String format;
    private final String filenamePrefix;
    private final String compression;
    private final Integer numShards;
    private final String shardNameTemplate;
    private final String filenameSuffix;
    private final FileWriteSchemaTransformConfiguration.CsvConfiguration csvConfiguration;
    private final FileWriteSchemaTransformConfiguration.ParquetConfiguration parquetConfiguration;
    private final FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfiguration;

    private AutoValue_FileWriteSchemaTransformConfiguration(String format, String filenamePrefix, @Nullable String compression, @Nullable Integer numShards, @Nullable String shardNameTemplate, @Nullable String filenameSuffix, @Nullable FileWriteSchemaTransformConfiguration.CsvConfiguration csvConfiguration, @Nullable FileWriteSchemaTransformConfiguration.ParquetConfiguration parquetConfiguration, @Nullable FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfiguration) {
        this.format = format;
        this.filenamePrefix = filenamePrefix;
        this.compression = compression;
        this.numShards = numShards;
        this.shardNameTemplate = shardNameTemplate;
        this.filenameSuffix = filenameSuffix;
        this.csvConfiguration = csvConfiguration;
        this.parquetConfiguration = parquetConfiguration;
        this.xmlConfiguration = xmlConfiguration;
    }

    @Override
    @SchemaFieldDescription(value="The format of the file content. Value must be one of: \"avro\", \"csv\", \"json\", \"parquet\", \"xml\"")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="A common prefix to use for all generated filenames.")
    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The compression of all generated shard files. By default, appends the respective extension to the filename. Valid options can be found in: https://beam.apache.org/releases/javadoc/2.46.0/org/apache/beam/sdk/io/Compression.html")
    public String getCompression() {
        return this.compression;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The number of output shards produced; a value of 1 disables sharding.")
    public Integer getNumShards() {
        return this.numShards;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Uses the given shard name template for naming output files.")
    public String getShardNameTemplate() {
        return this.shardNameTemplate;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Configures the filename suffix for written files.")
    public String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Configures extra details related to writing CSV formatted files.")
    public FileWriteSchemaTransformConfiguration.CsvConfiguration getCsvConfiguration() {
        return this.csvConfiguration;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Configures extra details related to writing Parquet formatted files.")
    public FileWriteSchemaTransformConfiguration.ParquetConfiguration getParquetConfiguration() {
        return this.parquetConfiguration;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Configures extra details related to writing XML formatted files.")
    public FileWriteSchemaTransformConfiguration.XmlConfiguration getXmlConfiguration() {
        return this.xmlConfiguration;
    }

    public String toString() {
        return "FileWriteSchemaTransformConfiguration{format=" + this.format + ", filenamePrefix=" + this.filenamePrefix + ", compression=" + this.compression + ", numShards=" + this.numShards + ", shardNameTemplate=" + this.shardNameTemplate + ", filenameSuffix=" + this.filenameSuffix + ", csvConfiguration=" + this.csvConfiguration + ", parquetConfiguration=" + this.parquetConfiguration + ", xmlConfiguration=" + this.xmlConfiguration + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileWriteSchemaTransformConfiguration) {
            FileWriteSchemaTransformConfiguration that = (FileWriteSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && this.filenamePrefix.equals(that.getFilenamePrefix()) && (this.compression == null ? that.getCompression() == null : this.compression.equals(that.getCompression())) && (this.numShards == null ? that.getNumShards() == null : this.numShards.equals(that.getNumShards())) && (this.shardNameTemplate == null ? that.getShardNameTemplate() == null : this.shardNameTemplate.equals(that.getShardNameTemplate())) && (this.filenameSuffix == null ? that.getFilenameSuffix() == null : this.filenameSuffix.equals(that.getFilenameSuffix())) && (this.csvConfiguration == null ? that.getCsvConfiguration() == null : this.csvConfiguration.equals(that.getCsvConfiguration())) && (this.parquetConfiguration == null ? that.getParquetConfiguration() == null : this.parquetConfiguration.equals(that.getParquetConfiguration())) && (this.xmlConfiguration == null ? that.getXmlConfiguration() == null : this.xmlConfiguration.equals(that.getXmlConfiguration()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenamePrefix.hashCode();
        h$ *= 1000003;
        h$ ^= this.compression == null ? 0 : this.compression.hashCode();
        h$ *= 1000003;
        h$ ^= this.numShards == null ? 0 : this.numShards.hashCode();
        h$ *= 1000003;
        h$ ^= this.shardNameTemplate == null ? 0 : this.shardNameTemplate.hashCode();
        h$ *= 1000003;
        h$ ^= this.filenameSuffix == null ? 0 : this.filenameSuffix.hashCode();
        h$ *= 1000003;
        h$ ^= this.csvConfiguration == null ? 0 : this.csvConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.parquetConfiguration == null ? 0 : this.parquetConfiguration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.xmlConfiguration == null ? 0 : this.xmlConfiguration.hashCode();
    }

    @Override
    FileWriteSchemaTransformConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FileWriteSchemaTransformConfiguration.Builder {
        private String format;
        private String filenamePrefix;
        private String compression;
        private Integer numShards;
        private String shardNameTemplate;
        private String filenameSuffix;
        private FileWriteSchemaTransformConfiguration.CsvConfiguration csvConfiguration;
        private FileWriteSchemaTransformConfiguration.ParquetConfiguration parquetConfiguration;
        private FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfiguration;

        Builder() {
        }

        private Builder(FileWriteSchemaTransformConfiguration source) {
            this.format = source.getFormat();
            this.filenamePrefix = source.getFilenamePrefix();
            this.compression = source.getCompression();
            this.numShards = source.getNumShards();
            this.shardNameTemplate = source.getShardNameTemplate();
            this.filenameSuffix = source.getFilenameSuffix();
            this.csvConfiguration = source.getCsvConfiguration();
            this.parquetConfiguration = source.getParquetConfiguration();
            this.xmlConfiguration = source.getXmlConfiguration();
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setFilenamePrefix(String filenamePrefix) {
            if (filenamePrefix == null) {
                throw new NullPointerException("Null filenamePrefix");
            }
            this.filenamePrefix = filenamePrefix;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setCompression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setNumShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setShardNameTemplate(String shardNameTemplate) {
            this.shardNameTemplate = shardNameTemplate;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setFilenameSuffix(String filenameSuffix) {
            this.filenameSuffix = filenameSuffix;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setCsvConfiguration(FileWriteSchemaTransformConfiguration.CsvConfiguration csvConfiguration) {
            this.csvConfiguration = csvConfiguration;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setParquetConfiguration(FileWriteSchemaTransformConfiguration.ParquetConfiguration parquetConfiguration) {
            this.parquetConfiguration = parquetConfiguration;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration.Builder setXmlConfiguration(FileWriteSchemaTransformConfiguration.XmlConfiguration xmlConfiguration) {
            this.xmlConfiguration = xmlConfiguration;
            return this;
        }

        @Override
        public FileWriteSchemaTransformConfiguration build() {
            if (this.format == null || this.filenamePrefix == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.filenamePrefix == null) {
                    missing.append(" filenamePrefix");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FileWriteSchemaTransformConfiguration(this.format, this.filenamePrefix, this.compression, this.numShards, this.shardNameTemplate, this.filenameSuffix, this.csvConfiguration, this.parquetConfiguration, this.xmlConfiguration);
        }
    }
}

