/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.fileschematransform.FileReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_FileReadSchemaTransformConfiguration
extends FileReadSchemaTransformConfiguration {
    private final String format;
    private final String filepattern;
    private final String schema;
    private final Long pollIntervalMillis;
    private final Long terminateAfterSecondsSinceNewOutput;

    private AutoValue_FileReadSchemaTransformConfiguration(String format, @Nullable String filepattern, @Nullable String schema, @Nullable Long pollIntervalMillis, @Nullable Long terminateAfterSecondsSinceNewOutput) {
        this.format = format;
        this.filepattern = filepattern;
        this.schema = schema;
        this.pollIntervalMillis = pollIntervalMillis;
        this.terminateAfterSecondsSinceNewOutput = terminateAfterSecondsSinceNewOutput;
    }

    @Override
    @SchemaFieldDescription(value="The format of the file(s) to read. Possible values are \"lines\", \"avro\", \"parquet\", \"json\".")
    public String getFormat() {
        return this.format;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The filepattern used to match and read files. May instead use an input PCollection<Row> of filepatterns. To do so, each Row must have a \"filepattern\" String field containing the filepattern.")
    public String getFilepattern() {
        return this.filepattern;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The schema used by sources to deserialize data and create Beam Rows. May provide either a String representation of the schema or a single path to a file that contains the schema.")
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The time, in milliseconds, to wait before polling for new files. This will set the pipeline to be a streaming pipeline that continuously watches for new files.Note: This only polls for new files. New updates to an existing file will not be watched for.")
    public Long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="If no new files are found after this many seconds, this transform will cease to watch for new files. The default is to never terminate. To set this parameter, a poll interval must also be provided.")
    public Long getTerminateAfterSecondsSinceNewOutput() {
        return this.terminateAfterSecondsSinceNewOutput;
    }

    public String toString() {
        return "FileReadSchemaTransformConfiguration{format=" + this.format + ", filepattern=" + this.filepattern + ", schema=" + this.schema + ", pollIntervalMillis=" + this.pollIntervalMillis + ", terminateAfterSecondsSinceNewOutput=" + this.terminateAfterSecondsSinceNewOutput + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FileReadSchemaTransformConfiguration) {
            FileReadSchemaTransformConfiguration that = (FileReadSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && (this.pollIntervalMillis == null ? that.getPollIntervalMillis() == null : this.pollIntervalMillis.equals(that.getPollIntervalMillis())) && (this.terminateAfterSecondsSinceNewOutput == null ? that.getTerminateAfterSecondsSinceNewOutput() == null : this.terminateAfterSecondsSinceNewOutput.equals(that.getTerminateAfterSecondsSinceNewOutput()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.pollIntervalMillis == null ? 0 : this.pollIntervalMillis.hashCode();
        h$ *= 1000003;
        return h$ ^= this.terminateAfterSecondsSinceNewOutput == null ? 0 : this.terminateAfterSecondsSinceNewOutput.hashCode();
    }

    @Override
    FileReadSchemaTransformConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FileReadSchemaTransformConfiguration.Builder {
        private String format;
        private String filepattern;
        private String schema;
        private Long pollIntervalMillis;
        private Long terminateAfterSecondsSinceNewOutput;

        Builder() {
        }

        private Builder(FileReadSchemaTransformConfiguration source) {
            this.format = source.getFormat();
            this.filepattern = source.getFilepattern();
            this.schema = source.getSchema();
            this.pollIntervalMillis = source.getPollIntervalMillis();
            this.terminateAfterSecondsSinceNewOutput = source.getTerminateAfterSecondsSinceNewOutput();
        }

        @Override
        public FileReadSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public FileReadSchemaTransformConfiguration.Builder setFilepattern(String filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        public FileReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public FileReadSchemaTransformConfiguration.Builder setPollIntervalMillis(Long pollIntervalMillis) {
            this.pollIntervalMillis = pollIntervalMillis;
            return this;
        }

        @Override
        public FileReadSchemaTransformConfiguration.Builder setTerminateAfterSecondsSinceNewOutput(Long terminateAfterSecondsSinceNewOutput) {
            this.terminateAfterSecondsSinceNewOutput = terminateAfterSecondsSinceNewOutput;
            return this;
        }

        @Override
        FileReadSchemaTransformConfiguration autoBuild() {
            if (this.format == null) {
                String missing = " format";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FileReadSchemaTransformConfiguration(this.format, this.filepattern, this.schema, this.pollIntervalMillis, this.terminateAfterSecondsSinceNewOutput);
        }
    }
}

