/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.io.parquet.ParquetIO;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ParquetWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    @Override
    protected String getFormat() {
        return "parquet";
    }

    @Override
    protected String getFilenamePrefix() {
        return "";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, org.apache.beam.sdk.schemas.Schema beamSchema) {
        Schema avroSchema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)beamSchema);
        List expected = rows.stream().map(arg_0 -> ((SerializableFunction)AvroUtils.getRowToGenericRecordFunction((Schema)avroSchema)).apply(arg_0)).collect(Collectors.toList());
        PCollection actual = (PCollection)this.readPipeline.apply((PTransform)ParquetIO.read((Schema)avroSchema).from(folder + "/" + this.getFilenamePrefix() + "*").withProjection(avroSchema, avroSchema));
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return FileWriteSchemaTransformConfiguration.builder().setParquetConfiguration(FileWriteSchemaTransformConfiguration.parquetConfigurationBuilder().setCompressionCodecName(CompressionCodecName.GZIP.name()).build()).setFormat(this.getFormat()).setFilenamePrefix(folder + this.getFilenamePrefix()).build();
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$XmlConfiguration is not compatible with a parquet format");
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$CsvConfiguration is not compatible with a parquet format");
    }
}

