/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTestData;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.csv.CSVFormat;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CsvWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    @Rule
    public TestPipeline errorPipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Override
    protected String getFormat() {
        return "csv";
    }

    @Override
    protected String getFilenamePrefix() {
        return "/out";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, Schema beamSchema) {
        PCollection actual = (PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(folder + "*"));
        CSVFormat csvFormat = CSVFormat.Predefined.valueOf((String)Objects.requireNonNull(this.buildConfiguration(folder).getCsvConfiguration()).getPredefinedCsvFormat()).getFormat();
        List<String> expected = CsvWriteSchemaTransformFormatProviderTest.toCsv(rows, beamSchema, csvFormat);
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
    }

    private static List<String> toCsv(List<Row> rows, Schema beamSchema, CSVFormat csvFormat) {
        beamSchema = beamSchema.sorted();
        ArrayList<String> result = new ArrayList<String>();
        csvFormat = csvFormat.withSkipHeaderRecord().withHeader(new String[0]);
        String header = csvFormat.format(beamSchema.getFieldNames().toArray());
        result.add(header);
        for (Row row : rows) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String column : beamSchema.getFieldNames()) {
                values.add(row.getValue(column));
            }
            String record = csvFormat.format(values.toArray());
            result.add(record);
        }
        return result;
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return this.defaultConfiguration(folder).toBuilder().setNumShards(Integer.valueOf(1)).setCsvConfiguration(FileWriteSchemaTransformConfiguration.csvConfigurationBuilder().setPredefinedCsvFormat(CSVFormat.Predefined.Default.name()).build()).build();
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$ParquetConfiguration is not compatible with a csv format");
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$XmlConfiguration is not compatible with a csv format");
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.empty();
    }

    @Override
    public void arrayPrimitiveDataTypes() {
        this.assertThrowsWith("columns in header match fields in Schema with invalid types: integerList,stringList,doubleList,floatList,booleanList,longList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", "arrayPrimitiveDataTypes", FileWriteSchemaTransformFormatProviderTestData.DATA.arrayPrimitiveDataTypesRows, SchemaAwareJavaBeans.ARRAY_PRIMITIVE_DATA_TYPES_SCHEMA);
    }

    @Override
    public void doublyNestedDataTypesRepeat() {
        this.assertThrowsWith("columns in header match fields in Schema with invalid types: singlyNestedDataTypes,singlyNestedDataTypesList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", "doublyNestedDataTypesRepeat", FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesRepeatRows, SchemaAwareJavaBeans.DOUBLY_NESTED_DATA_TYPES_SCHEMA);
    }

    @Override
    public void doublyNestedDataTypesNoRepeat() {
        this.assertThrowsWith("columns in header match fields in Schema with invalid types: singlyNestedDataTypes,singlyNestedDataTypesList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", "doublyNestedDataTypesNoRepeat", FileWriteSchemaTransformFormatProviderTestData.DATA.doublyNestedDataTypesNoRepeatRows, SchemaAwareJavaBeans.DOUBLY_NESTED_DATA_TYPES_SCHEMA);
    }

    @Override
    public void singlyNestedDataTypesRepeated() {
        this.assertThrowsWith("columns in header match fields in Schema with invalid types: allPrimitiveDataTypes,allPrimitiveDataTypesList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", "singlyNestedDataTypesRepeated", FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesRepeatedRows, SchemaAwareJavaBeans.SINGLY_NESTED_DATA_TYPES_SCHEMA);
    }

    @Override
    public void singlyNestedDataTypesNoRepeat() {
        this.assertThrowsWith("columns in header match fields in Schema with invalid types: allPrimitiveDataTypes,allPrimitiveDataTypesList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", "singlyNestedDataTypesNoRepeat", FileWriteSchemaTransformFormatProviderTestData.DATA.singlyNestedDataTypesNoRepeatRows, SchemaAwareJavaBeans.SINGLY_NESTED_DATA_TYPES_SCHEMA);
    }

    private void assertThrowsWith(String expectedMessage, String name, List<Row> rows, Schema schema) {
        PCollection input = (PCollection)this.errorPipeline.apply((PTransform)Create.of(rows).withRowSchema(schema));
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(name);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)name, IllegalArgumentException.class, () -> {
            PCollection cfr_ignored_0 = (PCollection)input.apply(this.getProvider().buildTransform(configuration, schema));
        });
        Assert.assertEquals((String)name, (Object)expectedMessage, (Object)exception.getMessage());
    }

    @Override
    public void timeContaining() {
        PCollection invalidInput = (PCollection)this.errorPipeline.apply((PTransform)Create.of(FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows).withRowSchema(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA));
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration("timeContaining");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"Schema should throw Exception for containing a field with a repeated type", IllegalArgumentException.class, () -> {
            PCollection cfr_ignored_0 = (PCollection)invalidInput.apply(this.getProvider().buildTransform(configuration, SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA));
        });
        Assert.assertEquals((Object)"columns in header match fields in Schema with invalid types: instantList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", (Object)exception.getMessage());
    }

    @Test
    public void timeContainingSchemaWithListRemovedShouldWriteCSV() {
        String prefix = this.folder(SchemaAwareJavaBeans.TimeContaining.class, "timeContainingSchemaWithListRemovedShouldWriteCSV");
        String validField = "instant";
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows).withRowSchema(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA));
        PCollection modifiedInput = (PCollection)input.apply((PTransform)Select.fieldNames((String[])new String[]{validField}));
        Schema modifiedSchema = modifiedInput.getSchema();
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(prefix);
        PCollection result = (PCollection)modifiedInput.apply(this.getProvider().buildTransform(configuration, modifiedSchema));
        PCollection numFiles = (PCollection)result.apply(Count.globally());
        PAssert.thatSingleton((PCollection)numFiles).isEqualTo((Object)1L);
        this.writePipeline.run().waitUntilFinish();
        PCollection csv = (PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(configuration.getFilenamePrefix() + "*"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(validField);
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.timeContainingRows) {
            expected.add(formatter.print((ReadableInstant)row.getDateTime(validField)));
        }
        PAssert.that((PCollection)csv).containsInAnyOrder(expected);
        this.readPipeline.run();
    }

    @Test
    public void byteTypeNonRepeated() {
        System.out.println("BYTE TYPE NON REPEATED");
        String prefix = this.folder(SchemaAwareJavaBeans.ByteType.class, "byteTypeNonRepeated");
        String validField = "byte";
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(FileWriteSchemaTransformFormatProviderTestData.DATA.byteTypeRows).withRowSchema(SchemaAwareJavaBeans.BYTE_TYPE_SCHEMA));
        PCollection modifiedInput = (PCollection)input.apply((PTransform)Select.fieldNames((String[])new String[]{validField}));
        Schema modifiedSchema = modifiedInput.getSchema();
        FileWriteSchemaTransformConfiguration configuration = this.buildConfiguration(prefix);
        PCollection result = (PCollection)modifiedInput.apply(this.getProvider().buildTransform(configuration, modifiedSchema));
        PCollection numFiles = (PCollection)result.apply(Count.globally());
        PAssert.thatSingleton((PCollection)numFiles).isEqualTo((Object)1L);
        this.writePipeline.run().waitUntilFinish();
        PCollection csv = (PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(configuration.getFilenamePrefix() + "*"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(validField);
        for (Row row : FileWriteSchemaTransformFormatProviderTestData.DATA.byteTypeRows) {
            expected.add(row.getByte(validField).toString());
        }
        PAssert.that((PCollection)csv).containsInAnyOrder(expected);
        this.readPipeline.run();
    }
}

