/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fileschematransform;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroIO;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformFormatProviderTest;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AvroWriteSchemaTransformFormatProviderTest
extends FileWriteSchemaTransformFormatProviderTest {
    @Override
    protected String getFormat() {
        return "avro";
    }

    @Override
    protected String getFilenamePrefix() {
        return "/";
    }

    @Override
    protected void assertFolderContainsInAnyOrder(String folder, List<Row> rows, org.apache.beam.sdk.schemas.Schema beamSchema) {
        Schema avroSchema = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)beamSchema);
        AvroGenericCoder coder = AvroGenericCoder.of((Schema)avroSchema);
        List expected = rows.stream().map(arg_0 -> ((SerializableFunction)AvroUtils.getRowToGenericRecordFunction((Schema)avroSchema)).apply(arg_0)).collect(Collectors.toList());
        PCollection actual = ((PCollection)this.readPipeline.apply((PTransform)AvroIO.readGenericRecords((Schema)avroSchema).from(folder + this.getFilenamePrefix() + "*"))).setCoder((Coder)coder);
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
    }

    @Override
    protected FileWriteSchemaTransformConfiguration buildConfiguration(String folder) {
        return this.defaultConfiguration(folder);
    }

    @Override
    protected Optional<String> expectedErrorWhenCompressionSet() {
        return Optional.of("configuration with compression is not compatible with AvroIO");
    }

    @Override
    protected Optional<String> expectedErrorWhenParquetConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$ParquetConfiguration is not compatible with a avro format");
    }

    @Override
    protected Optional<String> expectedErrorWhenXmlConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$XmlConfiguration is not compatible with a avro format");
    }

    @Override
    protected Optional<String> expectedErrorWhenNumShardsSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenShardNameTemplateSet() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> expectedErrorWhenCsvConfigurationSet() {
        return Optional.of("configuration with org.apache.beam.sdk.io.fileschematransform.FileWriteSchemaTransformConfiguration$CsvConfiguration is not compatible with a avro format");
    }
}

