/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.io.IOException;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.io.elasticsearch.ElasticSearchIOTestUtils;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.elasticsearch.client.RestClient;
import org.joda.time.Instant;

public class ElasticsearchTestDataSet {
    public static final String ES_INDEX = "beam";
    public static final String ES_TYPE = "test";
    public static final long NUM_DOCS = 60000L;
    public static final int AVERAGE_DOC_SIZE = 25;
    public static final int MAX_DOC_SIZE = 35;
    private static String writeIndex = "beam" + Instant.now().getMillis();

    public static void main(String[] args) throws Exception {
        PipelineOptionsFactory.register(IOTestPipelineOptions.class);
        IOTestPipelineOptions options = (IOTestPipelineOptions)PipelineOptionsFactory.fromArgs((String[])args).as(IOTestPipelineOptions.class);
        ElasticsearchTestDataSet.createAndPopulateReadIndex(options);
    }

    private static void createAndPopulateReadIndex(IOTestPipelineOptions options) throws Exception {
        try (RestClient restClient = ElasticsearchTestDataSet.getConnectionConfiguration(options, ReadOrWrite.READ).createClient();){
            ElasticSearchIOTestUtils.insertTestDocuments(ES_INDEX, ES_TYPE, 60000L, restClient);
        }
    }

    static ElasticsearchIO.ConnectionConfiguration getConnectionConfiguration(IOTestPipelineOptions options, ReadOrWrite rOw) throws IOException {
        ElasticsearchIO.ConnectionConfiguration connectionConfiguration = ElasticsearchIO.ConnectionConfiguration.create((String[])new String[]{"http://" + options.getElasticsearchServer() + ":" + options.getElasticsearchHttpPort()}, (String)(rOw == ReadOrWrite.READ ? ES_INDEX : writeIndex), (String)ES_TYPE);
        return connectionConfiguration;
    }

    static void deleteIndex(RestClient restClient, ReadOrWrite rOw) throws Exception {
        ElasticSearchIOTestUtils.deleteIndex(rOw == ReadOrWrite.READ ? ES_INDEX : writeIndex, restClient);
    }

    public static enum ReadOrWrite {
        READ,
        WRITE;

    }
}

