/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.util.List;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.common.IOTestPipelineOptions;
import org.apache.beam.sdk.io.elasticsearch.ElasticSearchIOTestUtils;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchTestDataSet;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.elasticsearch.client.RestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIOIT {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchIOIT.class);
    private static RestClient restClient;
    private static IOTestPipelineOptions options;
    private static ElasticsearchIO.ConnectionConfiguration readConnectionConfiguration;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void beforeClass() throws Exception {
        PipelineOptionsFactory.register(IOTestPipelineOptions.class);
        options = (IOTestPipelineOptions)TestPipeline.testingPipelineOptions().as(IOTestPipelineOptions.class);
        readConnectionConfiguration = ElasticsearchTestDataSet.getConnectionConfiguration(options, ElasticsearchTestDataSet.ReadOrWrite.READ);
        restClient = readConnectionConfiguration.createClient();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ElasticsearchTestDataSet.deleteIndex(restClient, ElasticsearchTestDataSet.ReadOrWrite.WRITE);
        restClient.close();
    }

    @Test
    public void testSplitsVolume() throws Exception {
        ElasticsearchIO.Read read = ElasticsearchIO.read().withConnectionConfiguration(readConnectionConfiguration);
        ElasticsearchIO.BoundedElasticsearchSource initialSource = new ElasticsearchIO.BoundedElasticsearchSource(read, null);
        long desiredBundleSizeBytes = 0L;
        List splits = initialSource.split(desiredBundleSizeBytes, (PipelineOptions)options);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)initialSource, (List)splits, (PipelineOptions)options);
        long expectedNumSplits = 5L;
        Assert.assertEquals((long)expectedNumSplits, (long)splits.size());
        int nonEmptySplits = 0;
        for (BoundedSource subSource : splits) {
            if (SourceTestUtils.readFromSource((BoundedSource)subSource, (PipelineOptions)options).size() <= 0) continue;
            ++nonEmptySplits;
        }
        Assert.assertEquals((long)expectedNumSplits, (long)nonEmptySplits);
    }

    @Test
    public void testReadVolume() throws Exception {
        PCollection output = (PCollection)this.pipeline.apply((PTransform)ElasticsearchIO.read().withConnectionConfiguration(readConnectionConfiguration));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count", Count.globally()))).isEqualTo((Object)60000L);
        this.pipeline.run();
    }

    @Test
    public void testWriteVolume() throws Exception {
        ElasticsearchIO.ConnectionConfiguration writeConnectionConfiguration = ElasticsearchTestDataSet.getConnectionConfiguration(options, ElasticsearchTestDataSet.ReadOrWrite.WRITE);
        List<String> data = ElasticSearchIOTestUtils.createDocuments(60000L, ElasticSearchIOTestUtils.InjectionMode.DO_NOT_INJECT_INVALID_DOCS);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(data))).apply((PTransform)ElasticsearchIO.write().withConnectionConfiguration(writeConnectionConfiguration));
        this.pipeline.run();
        long currentNumDocs = ElasticSearchIOTestUtils.refreshIndexAndGetCurrentNumDocs("beam", "test", restClient);
        Assert.assertEquals((long)60000L, (long)currentNumDocs);
    }

    @Test
    public void testEstimatedSizesVolume() throws Exception {
        ElasticsearchIO.Read read = ElasticsearchIO.read().withConnectionConfiguration(readConnectionConfiguration);
        ElasticsearchIO.BoundedElasticsearchSource initialSource = new ElasticsearchIO.BoundedElasticsearchSource(read, null);
        long estimatedSize = initialSource.getEstimatedSizeBytes((PipelineOptions)options);
        LOG.info("Estimated size: {}", (Object)estimatedSize);
        MatcherAssert.assertThat((String)"Wrong estimated size bellow minimum", (Object)estimatedSize, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1500000L)));
        MatcherAssert.assertThat((String)"Wrong estimated size beyond maximum", (Object)estimatedSize, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0x200B20L)));
    }
}

