/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

class ElasticSearchIOTestUtils {
    ElasticSearchIOTestUtils() {
    }

    static void deleteIndex(String index, RestClient restClient) throws IOException {
        block2: {
            try {
                restClient.performRequest("DELETE", String.format("/%s", index), new Header[]{new BasicHeader("", "")});
            }
            catch (IOException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block2;
                throw e;
            }
        }
    }

    static void insertTestDocuments(String index, String type, long numDocs, RestClient restClient) throws IOException {
        List<String> data = ElasticSearchIOTestUtils.createDocuments(numDocs, InjectionMode.DO_NOT_INJECT_INVALID_DOCS);
        StringBuilder bulkRequest = new StringBuilder();
        for (String document : data) {
            bulkRequest.append(String.format("{ \"index\" : {} }%n%s%n", document));
        }
        String endPoint = String.format("/%s/%s/_bulk", index, type);
        NStringEntity requestBody = new NStringEntity(bulkRequest.toString(), ContentType.APPLICATION_JSON);
        Response response = restClient.performRequest("POST", endPoint, Collections.singletonMap("refresh", "true"), (HttpEntity)requestBody, new Header[]{new BasicHeader("", "")});
        JsonNode searchResult = ElasticsearchIO.parseResponse((Response)response);
        boolean errors = searchResult.path("errors").asBoolean();
        if (errors) {
            throw new IOException(String.format("Failed to insert test documents in index %s", index));
        }
    }

    static long refreshIndexAndGetCurrentNumDocs(String index, String type, RestClient restClient) throws IOException {
        long result;
        block2: {
            result = 0L;
            try {
                String endPoint = String.format("/%s/_refresh", index);
                restClient.performRequest("POST", endPoint, new Header[]{new BasicHeader("", "")});
                endPoint = String.format("/%s/%s/_search", index, type);
                Response response = restClient.performRequest("GET", endPoint, new Header[]{new BasicHeader("", "")});
                JsonNode searchResult = ElasticsearchIO.parseResponse((Response)response);
                result = searchResult.path("hits").path("total").asLong();
            }
            catch (IOException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block2;
                throw e;
            }
        }
        return result;
    }

    static List<String> createDocuments(long numDocs, InjectionMode injectionMode) {
        String[] scientists = new String[]{"Einstein", "Darwin", "Copernicus", "Pasteur", "Curie", "Faraday", "Newton", "Bohr", "Galilei", "Maxwell"};
        ArrayList<String> data = new ArrayList<String>();
        int i = 0;
        while ((long)i < numDocs) {
            int index = i % scientists.length;
            if (InjectionMode.INJECT_SOME_INVALID_DOCS.equals((Object)injectionMode) && (i == 6 || i == 7)) {
                data.add(String.format("{\"scientist\";\"%s\", \"id\":%d}", scientists[index], i));
            } else {
                data.add(String.format("{\"scientist\":\"%s\", \"id\":%d}", scientists[index], i));
            }
            ++i;
        }
        return data;
    }

    static enum InjectionMode {
        INJECT_SOME_INVALID_DOCS,
        DO_NOT_INJECT_INVALID_DOCS;

    }
}

