/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOTestCommon;
import org.apache.beam.sdk.testing.TestPipeline;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.transport.Netty4Plugin;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
public class ElasticsearchIOTest
extends ESIntegTestCase
implements Serializable {
    private ElasticsearchIOTestCommon elasticsearchIOTestCommon;
    private ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private String[] fillAddresses() {
        ArrayList<String> result = new ArrayList<String>();
        for (InetSocketAddress address : ElasticsearchIOTest.cluster().httpAddresses()) {
            result.add(String.format("http://%s:%s", address.getHostString(), address.getPort()));
        }
        return result.toArray(new String[result.size()]);
    }

    protected Settings nodeSettings(int nodeOrdinal) {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        return Settings.builder().put(super.nodeSettings(nodeOrdinal)).put("http.enabled", "true").put("thread_pool.bulk.queue_size", 400).build();
    }

    public Settings indexSettings() {
        return Settings.builder().put(super.indexSettings()).put("index.store.stats_refresh_interval", 0).build();
    }

    protected Collection<Class<? extends Plugin>> nodePlugins() {
        ArrayList<Class<? extends Plugin>> plugins = new ArrayList<Class<? extends Plugin>>();
        plugins.add(Netty4Plugin.class);
        return plugins;
    }

    @Before
    public void setup() throws IOException {
        ElasticsearchIOTest.internalCluster().ensureAtMostNumDataNodes(1);
        if (this.connectionConfiguration == null) {
            this.connectionConfiguration = ElasticsearchIO.ConnectionConfiguration.create((String[])this.fillAddresses(), (String)ElasticsearchIOTestCommon.getEsIndex(), (String)"test").withSocketAndRetryTimeout(Integer.valueOf(120000)).withConnectTimeout(Integer.valueOf(5000));
            this.elasticsearchIOTestCommon = new ElasticsearchIOTestCommon(this.connectionConfiguration, ElasticsearchIOTest.getRestClient(), false);
        }
    }

    @Test
    public void testSizes() throws Exception {
        this.createIndex(new String[]{ElasticsearchIOTestCommon.getEsIndex()});
        this.elasticsearchIOTestCommon.testSizes();
    }

    @Test
    public void testRead() throws Exception {
        this.createIndex(new String[]{ElasticsearchIOTestCommon.getEsIndex()});
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testRead();
    }

    @Test
    public void testReadWithQuery() throws Exception {
        this.createIndex(new String[]{ElasticsearchIOTestCommon.getEsIndex()});
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testReadWithQuery();
    }

    @Test
    public void testWrite() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWrite();
    }

    @Test
    public void testWriteWithErrors() throws Exception {
        this.elasticsearchIOTestCommon.setExpectedException(this.expectedException);
        this.elasticsearchIOTestCommon.testWriteWithErrors();
    }

    @Test
    public void testWriteWithMaxBatchSize() throws Exception {
        this.elasticsearchIOTestCommon.testWriteWithMaxBatchSize();
    }

    @Test
    public void testWriteWithMaxBatchSizeBytes() throws Exception {
        this.elasticsearchIOTestCommon.testWriteWithMaxBatchSizeBytes();
    }

    @Test
    public void testSplit() throws Exception {
        this.createIndex(new String[]{ElasticsearchIOTestCommon.getEsIndex()});
        this.elasticsearchIOTestCommon.testSplit(2000);
    }

    @Test
    public void testWriteWithIdFn() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWriteWithIdFn();
    }

    @Test
    public void testWriteWithIndexFn() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWriteWithIndexFn();
    }

    @Test
    public void testWriteFullAddressing() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWriteWithFullAddressing();
    }

    @Test
    public void testWritePartialUpdate() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWritePartialUpdate();
    }

    @Test
    public void testReadWithMetadata() throws Exception {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testReadWithMetadata();
    }

    @Test
    public void testDefaultRetryPredicate() throws IOException {
        this.elasticsearchIOTestCommon.testDefaultRetryPredicate(ElasticsearchIOTest.getRestClient());
    }

    @Test
    public void testWriteRetry() throws Throwable {
        this.elasticsearchIOTestCommon.setExpectedException(this.expectedException);
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWriteRetry();
    }

    @Test
    public void testWriteRetryValidRequest() throws Throwable {
        this.elasticsearchIOTestCommon.setPipeline(this.pipeline);
        this.elasticsearchIOTestCommon.testWriteRetryValidRequest();
    }
}

