/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.io.common.NetworkTestHelper;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOTestCommon;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.http.Header;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ElasticsearchIOTest
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchIOTest.class);
    private static final String ES_IP = "127.0.0.1";
    private static final int MAX_STARTUP_WAITING_TIME_MSEC = 5000;
    private static int esHttpPort;
    private static Node node;
    private static RestClient restClient;
    private static ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
    private static ElasticsearchIOTestCommon elasticsearchIOTestCommon;
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws IOException {
        esHttpPort = NetworkTestHelper.getAvailableLocalPort();
        LOG.info("Starting embedded Elasticsearch instance ({})", (Object)esHttpPort);
        Settings.Builder settingsBuilder = Settings.settingsBuilder().put("cluster.name", "beam").put("http.enabled", "true").put("node.data", "true").put("path.data", TEMPORARY_FOLDER.getRoot().getPath()).put("path.home", TEMPORARY_FOLDER.getRoot().getPath()).put("node.name", "beam").put("network.host", ES_IP).put("http.port", esHttpPort).put("index.store.stats_refresh_interval", 0).put("threadpool.bulk.queue_size", 400);
        node = new Node(settingsBuilder.build());
        LOG.info("Elasticsearch node created");
        node.start();
        connectionConfiguration = ElasticsearchIO.ConnectionConfiguration.create((String[])new String[]{"http://127.0.0.1:" + esHttpPort}, (String)ElasticsearchIOTestCommon.getEsIndex(), (String)"test").withSocketAndRetryTimeout(Integer.valueOf(120000)).withConnectTimeout(Integer.valueOf(5000));
        restClient = connectionConfiguration.createClient();
        elasticsearchIOTestCommon = new ElasticsearchIOTestCommon(connectionConfiguration, restClient, false);
        int waitingTime = 0;
        int healthCheckFrequency = 500;
        while (waitingTime < 5000 && restClient.performRequest("HEAD", "/", new Header[0]).getStatusLine().getStatusCode() != 200) {
            try {
                Thread.sleep(healthCheckFrequency);
                waitingTime += healthCheckFrequency;
            }
            catch (InterruptedException e) {
                LOG.warn("Waiting thread was interrupted while waiting for connection to Elasticsearch to be available");
            }
        }
        if (waitingTime >= 5000) {
            throw new IOException("Max startup waiting for embedded Elasticsearch to start was exceeded");
        }
    }

    @AfterClass
    public static void afterClass() throws IOException {
        restClient.close();
        node.close();
    }

    @Before
    public void before() throws Exception {
        ElasticsearchIOTestUtils.deleteIndex((ElasticsearchIO.ConnectionConfiguration)connectionConfiguration, (RestClient)restClient);
    }

    @Test
    public void testSizes() throws Exception {
        elasticsearchIOTestCommon.testSizes();
    }

    @Test
    public void testRead() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testRead();
    }

    @Test
    public void testReadWithQueryString() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testReadWithQueryString();
    }

    @Test
    public void testReadWithQueryValueProvider() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testReadWithQueryValueProvider();
    }

    @Test
    public void testWrite() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWrite();
    }

    @Test
    public void testWriteWithErrors() throws Exception {
        elasticsearchIOTestCommon.setExpectedException(this.expectedException);
        elasticsearchIOTestCommon.testWriteWithErrors();
    }

    @Test
    public void testWriteWithMaxBatchSize() throws Exception {
        elasticsearchIOTestCommon.testWriteWithMaxBatchSize();
    }

    @Test
    public void testWriteWithMaxBatchSizeBytes() throws Exception {
        elasticsearchIOTestCommon.testWriteWithMaxBatchSizeBytes();
    }

    @Test
    public void testSplit() throws Exception {
        elasticsearchIOTestCommon.testSplit(0);
    }

    @Test
    public void testWriteWithIdFn() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteWithIdFn();
    }

    @Test
    public void testWriteWithIndexFn() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteWithIndexFn();
    }

    @Test
    public void testWriteWithTypeFn() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteWithTypeFn2x5x();
    }

    @Test
    public void testWriteFullAddressing() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteWithFullAddressing();
    }

    @Test
    public void testWritePartialUpdate() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWritePartialUpdate();
    }

    @Test
    public void testWritePartialUpdateWithErrors() throws Exception {
        ElasticsearchIO.ConnectionConfiguration connectionConfiguration = ElasticsearchIO.ConnectionConfiguration.create((String[])new String[]{"http://127.0.0.1:" + esHttpPort}, (String)"partial_update", (String)"test");
        ElasticsearchIOTestCommon elasticsearchIOTestCommonWithErrors = new ElasticsearchIOTestCommon(connectionConfiguration, restClient, false);
        elasticsearchIOTestCommonWithErrors.setPipeline(this.pipeline);
        elasticsearchIOTestCommonWithErrors.testWritePartialUpdateWithErrors();
    }

    @Test
    public void testReadWithMetadata() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testReadWithMetadata();
    }

    @Test
    public void testDefaultRetryPredicate() throws IOException {
        elasticsearchIOTestCommon.testDefaultRetryPredicate(restClient);
    }

    @Test
    public void testWriteRetry() throws Throwable {
        elasticsearchIOTestCommon.setExpectedException(this.expectedException);
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteRetry();
    }

    @Test
    public void testWriteRetryValidRequest() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testWriteRetryValidRequest();
    }

    static {
        TEMPORARY_FOLDER = new TemporaryFolder();
    }
}

