/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOITCommon;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOTestCommon;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIOTestUtils;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.elasticsearch.client.RestClient;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchIOIT {
    private static RestClient restClient;
    private static ElasticsearchIOITCommon.ElasticsearchPipelineOptions options;
    private static ElasticsearchIO.ConnectionConfiguration readConnectionConfiguration;
    private static ElasticsearchIO.ConnectionConfiguration writeConnectionConfiguration;
    private static ElasticsearchIO.ConnectionConfiguration updateConnectionConfiguration;
    private static ElasticsearchIOTestCommon elasticsearchIOTestCommon;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void beforeClass() throws Exception {
        PipelineOptionsFactory.register(ElasticsearchIOITCommon.ElasticsearchPipelineOptions.class);
        options = (ElasticsearchIOITCommon.ElasticsearchPipelineOptions)TestPipeline.testingPipelineOptions().as(ElasticsearchIOITCommon.ElasticsearchPipelineOptions.class);
        readConnectionConfiguration = ElasticsearchIOITCommon.getConnectionConfiguration((ElasticsearchIOITCommon.ElasticsearchPipelineOptions)options, (ElasticsearchIOITCommon.IndexMode)ElasticsearchIOITCommon.IndexMode.READ);
        writeConnectionConfiguration = ElasticsearchIOITCommon.getConnectionConfiguration((ElasticsearchIOITCommon.ElasticsearchPipelineOptions)options, (ElasticsearchIOITCommon.IndexMode)ElasticsearchIOITCommon.IndexMode.WRITE);
        updateConnectionConfiguration = ElasticsearchIOITCommon.getConnectionConfiguration((ElasticsearchIOITCommon.ElasticsearchPipelineOptions)options, (ElasticsearchIOITCommon.IndexMode)ElasticsearchIOITCommon.IndexMode.WRITE_PARTIAL);
        restClient = readConnectionConfiguration.createClient();
        elasticsearchIOTestCommon = new ElasticsearchIOTestCommon(readConnectionConfiguration, restClient, true);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ElasticsearchIOTestUtils.deleteIndex((ElasticsearchIO.ConnectionConfiguration)writeConnectionConfiguration, (RestClient)restClient);
        ElasticsearchIOTestUtils.deleteIndex((ElasticsearchIO.ConnectionConfiguration)updateConnectionConfiguration, (RestClient)restClient);
        restClient.close();
    }

    @Test
    public void testSplitsVolume() throws Exception {
        elasticsearchIOTestCommon.testSplit(0);
    }

    @Test
    public void testReadVolume() throws Exception {
        elasticsearchIOTestCommon.setPipeline(this.pipeline);
        elasticsearchIOTestCommon.testRead();
    }

    @Test
    public void testWriteVolume() throws Exception {
        ElasticsearchIOTestCommon elasticsearchIOTestCommonWrite = new ElasticsearchIOTestCommon(writeConnectionConfiguration, restClient, true);
        elasticsearchIOTestCommonWrite.setPipeline(this.pipeline);
        elasticsearchIOTestCommonWrite.testWrite();
    }

    @Test
    public void testSizesVolume() throws Exception {
        elasticsearchIOTestCommon.testSizes();
    }

    @Test
    public void testWriteVolumeWithFullAddressing() throws Exception {
        ElasticsearchIOTestCommon elasticsearchIOTestCommonWrite = new ElasticsearchIOTestCommon(writeConnectionConfiguration, restClient, true);
        elasticsearchIOTestCommonWrite.setPipeline(this.pipeline);
        elasticsearchIOTestCommonWrite.testWriteWithFullAddressing();
    }

    @Test
    public void testWritePartialUpdate() throws Exception {
        ElasticsearchIOTestUtils.copyIndex((RestClient)restClient, (String)readConnectionConfiguration.getIndex(), (String)updateConnectionConfiguration.getIndex());
        ElasticsearchIOTestCommon elasticsearchIOTestCommonUpdate = new ElasticsearchIOTestCommon(updateConnectionConfiguration, restClient, true);
        elasticsearchIOTestCommonUpdate.setPipeline(this.pipeline);
        elasticsearchIOTestCommonUpdate.testWritePartialUpdate();
    }
}

