/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.debezium;

import java.io.Serializable;
import org.apache.beam.io.debezium.SourceRecordJson;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SourceRecordJsonTest
implements Serializable {
    @Test
    public void testSourceRecordJson() {
        SourceRecord record = this.buildSourceRecord();
        SourceRecordJson json = new SourceRecordJson(record);
        String jsonString = json.toJson();
        String expectedJson = "{\"metadata\":{\"connector\":\"test-connector\",\"version\":\"version-connector\",\"name\":\"test-connector-sql\",\"database\":\"test-db\",\"schema\":\"test-schema\",\"table\":\"test-table\"},\"before\":{\"fields\":{\"column1\":\"before-name\"}},\"after\":{\"fields\":{\"column1\":\"after-name\"}}}";
        Assert.assertEquals((Object)expectedJson, (Object)jsonString);
    }

    @Test
    public void testSourceRecordJsonWhenSourceRecordIsNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new SourceRecordJson(null));
    }

    private Schema buildSourceSchema() {
        return SchemaBuilder.struct().field("connector", Schema.STRING_SCHEMA).field("version", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("db", Schema.STRING_SCHEMA).field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).build();
    }

    private Schema buildBeforeSchema() {
        return SchemaBuilder.struct().field("column1", Schema.STRING_SCHEMA).build();
    }

    private Schema buildAfterSchema() {
        return SchemaBuilder.struct().field("column1", Schema.STRING_SCHEMA).build();
    }

    private SourceRecord buildSourceRecord() {
        Schema sourceSchema = this.buildSourceSchema();
        Schema beforeSchema = this.buildBeforeSchema();
        Schema afterSchema = this.buildAfterSchema();
        Schema schema = SchemaBuilder.struct().name("test").field("source", sourceSchema).field("before", beforeSchema).field("after", afterSchema).build();
        Struct source = new Struct(sourceSchema);
        Struct before = new Struct(beforeSchema);
        Struct after = new Struct(afterSchema);
        Struct value = new Struct(schema);
        source.put("connector", (Object)"test-connector");
        source.put("version", (Object)"version-connector");
        source.put("name", (Object)"test-connector-sql");
        source.put("db", (Object)"test-db");
        source.put("schema", (Object)"test-schema");
        source.put("table", (Object)"test-table");
        before.put("column1", (Object)"before-name");
        after.put("column1", (Object)"after-name");
        value.put("source", (Object)source);
        value.put("before", (Object)before);
        value.put("after", (Object)after);
        return new SourceRecord(null, null, null, schema, (Object)value);
    }
}

