/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.debezium;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.io.debezium.CounterSourceConnector;
import org.apache.beam.io.debezium.CounterTask;
import org.apache.beam.io.debezium.KafkaSourceConsumerFn;
import org.apache.beam.io.debezium.SourceRecordMapper;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaSourceConsumerFnTest
implements Serializable {
    @Test
    public void testKafkaSourceConsumerFn() {
        ImmutableMap config = ImmutableMap.of((Object)"from", (Object)"1", (Object)"to", (Object)"10", (Object)"delay", (Object)"0.4", (Object)"topic", (Object)"any");
        Pipeline pipeline = Pipeline.create();
        PCollection counts = ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Iterable)Lists.newArrayList((Object[])new Map[]{config})).withCoder((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())))).apply((PTransform)ParDo.of((DoFn)new KafkaSourceConsumerFn(CounterSourceConnector.class, (SourceRecordMapper & Serializable)sourceRecord -> (Integer)sourceRecord.value(), 10L)))).setCoder((Coder)VarIntCoder.of());
        PAssert.that((PCollection)counts).containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        pipeline.run().waitUntilFinish();
    }

    @Test
    public void testStoppableKafkaSourceConsumerFn() {
        ImmutableMap config = ImmutableMap.of((Object)"from", (Object)"1", (Object)"to", (Object)"3", (Object)"delay", (Object)"0.2", (Object)"topic", (Object)"any");
        Pipeline pipeline = Pipeline.create();
        PCollection counts = ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Iterable)Lists.newArrayList((Object[])new Map[]{config})).withCoder((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())))).apply((PTransform)ParDo.of((DoFn)new KafkaSourceConsumerFn(CounterSourceConnector.class, (SourceRecordMapper & Serializable)sourceRecord -> (Integer)sourceRecord.value(), 1L)))).setCoder((Coder)VarIntCoder.of());
        pipeline.run().waitUntilFinish();
        Assert.assertEquals((long)3L, (long)CounterTask.getCountTasks());
    }
}

