/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.debezium;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.io.debezium.DebeziumIO;
import org.apache.beam.io.debezium.KafkaSourceConsumerFn;
import org.apache.kafka.common.config.ConfigValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class DebeziumIOTest
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumIOTest.class);
    private static final DebeziumIO.ConnectorConfiguration MYSQL_CONNECTOR_CONFIGURATION = DebeziumIO.ConnectorConfiguration.create().withUsername("debezium").withPassword("dbz").withHostName("127.0.0.1").withPort("3306").withConnectorClass(MySqlConnector.class).withConnectionProperty("database.server.id", "184054").withConnectionProperty("database.server.name", "dbserver1").withConnectionProperty("database.include.list", "inventory").withConnectionProperty("database.history", KafkaSourceConsumerFn.DebeziumSDFDatabaseHistory.class.getName()).withConnectionProperty("include.schema.changes", "false");

    @Test
    public void testSourceMySqlConnectorValidConfiguration() {
        Map configurationMap = MYSQL_CONNECTOR_CONFIGURATION.getConfigurationMap();
        Configuration debeziumConf = Configuration.from((Map)configurationMap);
        Map validConfig = debeziumConf.validate(MySqlConnectorConfig.ALL_FIELDS);
        for (ConfigValue configValue : validConfig.values()) {
            Assert.assertTrue((boolean)configValue.errorMessages().isEmpty());
        }
    }

    @Test
    public void testSourceConnectorUsernamePassword() {
        String username = "debezium";
        String password = "dbz";
        DebeziumIO.ConnectorConfiguration configuration = MYSQL_CONNECTOR_CONFIGURATION.withUsername(username).withPassword(password);
        Map configurationMap = configuration.getConfigurationMap();
        Configuration debeziumConf = Configuration.from((Map)configurationMap);
        Map validConfig = debeziumConf.validate(MySqlConnectorConfig.ALL_FIELDS);
        for (ConfigValue configValue : validConfig.values()) {
            Assert.assertTrue((boolean)configValue.errorMessages().isEmpty());
        }
    }

    @Test
    public void testSourceConnectorNullPassword() {
        String username = "debezium";
        String password = null;
        Assert.assertThrows(IllegalArgumentException.class, () -> MYSQL_CONNECTOR_CONFIGURATION.withUsername(username).withPassword(password));
    }

    @Test
    public void testSourceConnectorNullUsernameAndPassword() {
        String username = null;
        String password = null;
        Assert.assertThrows(IllegalArgumentException.class, () -> MYSQL_CONNECTOR_CONFIGURATION.withUsername(username).withPassword(password));
    }
}

