/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.debezium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;

class CounterTask
extends SourceTask {
    private static int countStopTasks = 0;
    private String topic = "";
    private Integer from = 0;
    private Integer to = 0;
    private Double delay = 0.0;
    private Long start = System.currentTimeMillis();
    private Integer last = 0;
    private Object lastOffset = null;
    private static final String PARTITION_FIELD = "mod";
    private static final Integer PARTITION_NAME = 1;

    CounterTask() {
    }

    public String version() {
        return "ONE";
    }

    public void initialize(SourceTaskContext context) {
        super.initialize(context);
        Map offset = context.offsetStorageReader().offset(Collections.singletonMap(PARTITION_FIELD, PARTITION_NAME));
        if (offset == null) {
            this.start = System.currentTimeMillis();
            this.last = 0;
        } else {
            this.start = (Long)offset.get("start");
            this.last = ((Long)((Object)offset.getOrDefault("last", 0))).intValue();
        }
        this.lastOffset = offset;
    }

    public void start(Map<String, String> props) {
        this.topic = props.getOrDefault("topic", "");
        this.from = Integer.parseInt(props.getOrDefault("from", "0"));
        this.to = Integer.parseInt(props.getOrDefault("to", "0"));
        this.delay = Double.parseDouble(props.getOrDefault("delay", "0"));
        if (this.lastOffset != null) {
            return;
        }
        this.start = props.containsKey("start") ? Long.parseLong(props.get("start")) : System.currentTimeMillis();
        this.last = this.from - 1;
    }

    public List<SourceRecord> poll() throws InterruptedException {
        if (this.last.equals(this.to)) {
            return null;
        }
        ArrayList<SourceRecord> records = new ArrayList<SourceRecord>();
        Long callTime = System.currentTimeMillis();
        Long secondsSinceStart = (callTime - this.start) / 1000L;
        Long recordsToOutput = Math.round(Math.floor((double)secondsSinceStart.longValue() / this.delay));
        while (this.last < this.to) {
            this.last = this.last + 1;
            Map<String, Integer> sourcePartition = Collections.singletonMap(PARTITION_FIELD, 1);
            ImmutableMap sourceOffset = ImmutableMap.of((Object)"last", (Object)this.last.longValue(), (Object)"start", (Object)this.start);
            records.add(new SourceRecord(sourcePartition, (Map)sourceOffset, this.topic, Schema.INT64_SCHEMA, (Object)this.last));
            if ((long)records.size() < recordsToOutput) continue;
            break;
        }
        return records;
    }

    public void stop() {
        ++countStopTasks;
    }

    public static int getCountTasks() {
        return countStopTasks;
    }
}

