/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.debezium;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.io.debezium.CounterTask;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.checkerframework.checker.nullness.qual.Nullable;

class CounterSourceConnector
extends SourceConnector {
    private @Nullable CounterSourceConnectorConfig connectorConfig;

    CounterSourceConnector() {
    }

    public void start(Map<String, String> props) {
        this.connectorConfig = new CounterSourceConnectorConfig(props);
    }

    public Class<? extends Task> taskClass() {
        return CounterTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (this.connectorConfig == null || this.connectorConfig.props == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ImmutableMap.of((Object)"from", (Object)this.connectorConfig.props.get("from"), (Object)"to", (Object)this.connectorConfig.props.get("to"), (Object)"delay", (Object)this.connectorConfig.props.get("delay"), (Object)"topic", (Object)this.connectorConfig.props.get("topic")));
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CounterSourceConnectorConfig.configDef();
    }

    public String version() {
        return "ONE";
    }

    public static class CounterSourceConnectorConfig
    extends AbstractConfig {
        final Map<String, String> props;

        CounterSourceConnectorConfig(Map<String, String> props) {
            super(CounterSourceConnectorConfig.configDef(), props);
            this.props = props;
        }

        protected static ConfigDef configDef() {
            return new ConfigDef().define("from", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "Number to start from").define("to", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "Number to go to").define("delay", ConfigDef.Type.DOUBLE, ConfigDef.Importance.HIGH, "Time between each event").define("topic", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Name of Kafka topic to produce to");
        }
    }
}

