/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.csv.CsvIOParseError;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CsvIOParseErrorTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private static final SchemaProvider SCHEMA_PROVIDER = new DefaultSchema.DefaultSchemaProvider();

    @Test
    public void usableInSingleOutput() {
        List<CsvIOParseError> want = Arrays.asList(CsvIOParseError.builder().setMessage("error message").setObservedTimestamp(Instant.now()).setStackTrace("stack trace").build(), CsvIOParseError.builder().setMessage("error message").setObservedTimestamp(Instant.now()).setStackTrace("stack trace").setFilename("filename").setCsvRecord("csv record").build());
        PCollection errors = (PCollection)this.pipeline.apply((PTransform)Create.of(want));
        PAssert.that((PCollection)errors).containsInAnyOrder(want);
        this.pipeline.run();
    }

    @Test
    public void usableInMultiOutput() {
        List<CsvIOParseError> want = Arrays.asList(CsvIOParseError.builder().setMessage("error message").setObservedTimestamp(Instant.now()).setStackTrace("stack trace").build(), CsvIOParseError.builder().setMessage("error message").setObservedTimestamp(Instant.now()).setStackTrace("stack trace").setFilename("filename").setCsvRecord("csv record").build());
        TupleTag<CsvIOParseError> errorTag = new TupleTag<CsvIOParseError>(){};
        TupleTag<String> anotherTag = new TupleTag<String>(){};
        PCollection errors = (PCollection)this.pipeline.apply("createWant", (PTransform)Create.of(want));
        PCollection anotherPCol = (PCollection)this.pipeline.apply("createAnother", (PTransform)Create.of((Object)"a", (Object[])new String[]{"b", "c"}));
        PCollectionTuple pct = PCollectionTuple.of((TupleTag)errorTag, (PCollection)errors).and((TupleTag)anotherTag, anotherPCol);
        PAssert.that((PCollection)pct.get((TupleTag)errorTag)).containsInAnyOrder(want);
        this.pipeline.run();
    }

    @Test
    public void canDeriveSchema() {
        TypeDescriptor type = TypeDescriptor.of(CsvIOParseError.class);
        Schema schema = SCHEMA_PROVIDER.schemaFor(type);
        Assert.assertNotNull((Object)schema);
        this.pipeline.run();
    }
}

