/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.csv.CsvIOTestData;
import org.apache.beam.sdk.io.csv.CsvRowConversions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.commons.csv.CSVFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowToCsvPredefinedCSVFormatsTest {
    @Test
    public void defaultFormat() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.defaultFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvPredefinedCSVFormatsTest.defaultFormat(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true,,,,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.defaultFormat(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.defaultFormat(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void excel() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.excel(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvPredefinedCSVFormatsTest.excel(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true,,,,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.excel(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.excel(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void informixUnload() {
        Assert.assertEquals((Object)"false|10|1.0|1.0|1|a|1", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnload(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)"|||||", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnload(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true||||a|1", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnload(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnload(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void informixUnloadCsv() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnloadCSV(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnloadCSV(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true,,,,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnloadCSV(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.informixUnloadCSV(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void mySql() {
        Assert.assertEquals((Object)"false\t10\t1.0\t1.0\t1\ta\t1", (Object)RowToCsvPredefinedCSVFormatsTest.mySql(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)"\\N\t\\N\t\\N\t\\N\t\\N\t\\N", (Object)RowToCsvPredefinedCSVFormatsTest.mySql(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true\t\\N\t\\N\t\\N\ta\t1", (Object)RowToCsvPredefinedCSVFormatsTest.mySql(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.mySql(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void rfc4180() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.rfc4180(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvPredefinedCSVFormatsTest.rfc4180(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true,,,,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.rfc4180(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.rfc4180(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void oracle() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.oracle(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)"\\N,\\N,\\N,\\N,\\N,\\N", (Object)RowToCsvPredefinedCSVFormatsTest.oracle(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true,\\N,\\N,\\N,a,1", (Object)RowToCsvPredefinedCSVFormatsTest.oracle(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.oracle(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void postgresqlCSV() {
        Assert.assertEquals((Object)"\"false\",\"10\",\"1.0\",\"1.0\",\"1\",\"a\",\"1\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlCSV(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlCSV(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"\"true\",,,,\"a\",\"1\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlCSV(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"\"1970-01-01T00:00:00.001Z\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlCSV(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void postgresqlText() {
        Assert.assertEquals((Object)"\"false\"\t\"10\"\t\"1.0\"\t\"1.0\"\t\"1\"\t\"a\"\t\"1\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlText(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)"\\N\t\\N\t\\N\t\\N\t\\N\t\\N", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlText(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"\"true\"\t\\N\t\\N\t\\N\t\"a\"\t\"1\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlText(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"\"1970-01-01T00:00:00.001Z\"", (Object)RowToCsvPredefinedCSVFormatsTest.postgresqlText(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    @Test
    public void tdf() {
        Assert.assertEquals((Object)"false\t10\t1.0\t1.0\t1\ta\t1", (Object)RowToCsvPredefinedCSVFormatsTest.tdf(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.allPrimitiveDataTypesRow));
        Assert.assertEquals((Object)"", (Object)RowToCsvPredefinedCSVFormatsTest.tdf(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowAllNull));
        Assert.assertEquals((Object)"true\t\t\t\ta\t1", (Object)RowToCsvPredefinedCSVFormatsTest.tdf(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA, new String[0]).apply(CsvIOTestData.DATA.nullableTypesRowSomeNull));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)RowToCsvPredefinedCSVFormatsTest.tdf(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA, "instant").apply(CsvIOTestData.DATA.timeContainingRow));
    }

    private static CsvRowConversions.RowToCsv defaultFormat(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.DEFAULT, schema, header);
    }

    private static CsvRowConversions.RowToCsv excel(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.EXCEL.withAllowMissingColumnNames(false), schema, header);
    }

    private static CsvRowConversions.RowToCsv informixUnload(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.INFORMIX_UNLOAD, schema, header);
    }

    private static CsvRowConversions.RowToCsv informixUnloadCSV(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.INFORMIX_UNLOAD_CSV, schema, header);
    }

    private static CsvRowConversions.RowToCsv mySql(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.MYSQL, schema, header);
    }

    private static CsvRowConversions.RowToCsv rfc4180(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.RFC4180, schema, header);
    }

    private static CsvRowConversions.RowToCsv oracle(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.ORACLE, schema, header);
    }

    private static CsvRowConversions.RowToCsv postgresqlCSV(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.POSTGRESQL_CSV, schema, header);
    }

    private static CsvRowConversions.RowToCsv postgresqlText(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.POSTGRESQL_TEXT, schema, header);
    }

    private static CsvRowConversions.RowToCsv tdf(Schema schema, String ... header) {
        return RowToCsvPredefinedCSVFormatsTest.rowToCsv(CSVFormat.TDF.withIgnoreSurroundingSpaces(false), schema, header);
    }

    private static CsvRowConversions.RowToCsv rowToCsv(CSVFormat csvFormat, Schema schema, String ... header) {
        if (header.length == 0) {
            header = schema.sorted().getFieldNames().toArray(new String[0]);
        }
        return CsvRowConversions.RowToCsv.builder().setCSVFormat(csvFormat.withHeader(header)).setSchema(schema).build();
    }
}

