/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.csv.CsvIOTestData;
import org.apache.beam.sdk.io.csv.CsvRowConversions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowToCsvCSVFormatTest {
    @Test
    public void invalidCSVFormatHeader() {
        NullPointerException nullHeaderError = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT).setSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).build());
        Assert.assertEquals((Object)"CSVFormat withHeader is required", (Object)nullHeaderError.getMessage());
        IllegalArgumentException emptyHeaderError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT.withHeader(new String[0])).setSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).build());
        Assert.assertEquals((Object)"CSVFormat withHeader requires at least one column", (Object)emptyHeaderError.getMessage());
        IllegalArgumentException mismatchHeaderError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT.withHeader(new String[]{"aString", "idontexist1", "idontexist2"})).setSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).build());
        Assert.assertEquals((Object)"columns in CSVFormat header do not exist in Schema: idontexist2,idontexist1", (Object)mismatchHeaderError.getMessage());
    }

    @Test
    public void invalidSchema() {
        IllegalArgumentException emptySchemaError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT.withHeader(new String[0])).setSchema(Schema.of((Schema.Field[])new Schema.Field[0])).build());
        Assert.assertEquals((Object)"Schema has no fields", (Object)emptySchemaError.getMessage());
        IllegalArgumentException invalidArrayFieldsError = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT.withHeader(new String[]{"instant", "instantList"})).setSchema(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA).build());
        Assert.assertEquals((Object)"columns in header match fields in Schema with invalid types: instantList. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", (Object)invalidArrayFieldsError.getMessage());
        CsvRowConversions.RowToCsv.builder().setCSVFormat(CSVFormat.DEFAULT.withHeader(new String[]{"instant"})).setSchema(SchemaAwareJavaBeans.TIME_CONTAINING_SCHEMA).build();
    }

    @Test
    public void withAllowDuplicateHeaderNamesDuplicatesRowFieldOutput() {
        Assert.assertEquals((String)"allowDuplicateHeaderNames=true", (Object)"a,a,a", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withAllowDuplicateHeaderNames(true).withHeader(new String[]{"aString", "aString", "aString"})));
    }

    @Test
    public void withAllowMissingColumnNamesSettingThrowsException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"allowMissingColumnNames=true", IllegalArgumentException.class, () -> RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withAllowMissingColumnNames(true)));
        Assert.assertEquals((Object)"withAllowMissingColumnNames is an illegal CSVFormat setting", (Object)exception.getMessage());
    }

    @Test
    public void withAutoFlushThrowsException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"autoFlush=true", IllegalArgumentException.class, () -> RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withAutoFlush(true)));
        Assert.assertEquals((Object)"withAutoFlush is an illegal CSVFormat setting", (Object)exception.getMessage());
    }

    @Test
    public void withCommentMarkerDoesNotEffectConversion() {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"aString", (Schema.FieldType)Schema.FieldType.STRING)});
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{"$abc"});
        Assert.assertEquals((Object)"$abc", (Object)RowToCsvCSVFormatTest.rowToCsv(row, RowToCsvCSVFormatTest.csvFormat(schema).withCommentMarker('$')));
        Assert.assertEquals((Object)"$abc", (Object)RowToCsvCSVFormatTest.rowToCsv(row, RowToCsvCSVFormatTest.csvFormat(schema).withCommentMarker(null)));
    }

    @Test
    public void withDelimiterDrivesCellBorders() {
        Assert.assertEquals((Object)"false~10~1.0~1.0~1~a~1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withDelimiter('~')));
    }

    @Test
    public void withEscapeDrivesOutput() {
        Schema schema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"aString", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"anInt", (Schema.FieldType)Schema.FieldType.INT32)});
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{",a", 1});
        String[] header = new String[]{"anInt", "aString"};
        Assert.assertEquals((Object)"1,#,a", (Object)RowToCsvCSVFormatTest.rowToCsv(row, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withHeader(header).withEscape('#').withQuoteMode(QuoteMode.NONE)));
        Assert.assertEquals((Object)"1,\",a\"", (Object)RowToCsvCSVFormatTest.rowToCsv(row, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withHeader(header)));
    }

    @Test
    public void withHeaderDrivesFieldOrderSubsetOutput() {
        Assert.assertEquals((Object)"1,false,a", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withHeader(new String[]{"anInteger", "aBoolean", "aString"})));
    }

    @Test
    public void withHeaderCommentsDoesNotEffectConversion() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withHeaderComments(new Object[]{"some", "header", "comments"})));
    }

    @Test
    public void withIgnoreEmptyLinesDoesNotEffectOutput() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withIgnoreEmptyLines(true)));
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withIgnoreEmptyLines(false)));
    }

    @Test
    public void withIgnoreHeaderCaseThrowsException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withIgnoreHeaderCase(true)));
        Assert.assertEquals((Object)"withIgnoreHeaderCase is an illegal CSVFormat setting", (Object)exception.getMessage());
    }

    @Test
    public void withIgnoreSurroundingSpacesThrowsException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withIgnoreSurroundingSpaces(true)));
        Assert.assertEquals((Object)"withIgnoreSurroundingSpaces is an illegal CSVFormat setting", (Object)exception.getMessage());
    }

    @Test
    public void withNullStringReplacesNullValues() {
        Assert.assertEquals((Object)"\ud83e\udd84,\ud83e\udd84,\ud83e\udd84,\ud83e\udd84,\ud83e\udd84,\ud83e\udd84", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.nullableTypesRowAllNull, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withNullString("\ud83e\udd84")));
    }

    @Test
    public void withQuoteDrivesConversion() {
        Assert.assertEquals((Object)"@false@,10,1.0,1.0,1,@a@,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuote('@').withQuoteMode(QuoteMode.NON_NUMERIC)));
    }

    @Test
    public void withQuoteModeDrivesCellBoundaries() {
        Assert.assertEquals((Object)"\"false\",\"10\",\"1.0\",\"1.0\",\"1\",\"a\",\"1\"", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuoteMode(QuoteMode.ALL)));
        Assert.assertEquals((Object)"\"false\",10,1.0,1.0,1,\"a\",1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuoteMode(QuoteMode.NON_NUMERIC)));
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuoteMode(QuoteMode.MINIMAL)));
        Assert.assertEquals((Object)",,,,,", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.nullableTypesRowAllNull, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuoteMode(QuoteMode.ALL_NON_NULL)));
        Assert.assertEquals((Object)"\"true\",,,,\"a\",\"1\"", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.nullableTypesRowSomeNull, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.NULLABLE_ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withQuoteMode(QuoteMode.ALL_NON_NULL)));
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withEscape('#').withQuoteMode(QuoteMode.NONE)));
    }

    @Test
    public void withSystemRecordSeparatorDoesNotEffectOutput() {
        Assert.assertEquals((Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA)), (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withSystemRecordSeparator()));
    }

    @Test
    public void withTrailingDelimiterAppendsToLineEnd() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1,", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRow, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withTrailingDelimiter(true)));
    }

    @Test
    public void withTrimRemovesCellPadding() {
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,\"       a           \",1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRowWithPadding, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA)));
        Assert.assertEquals((Object)"false,10,1.0,1.0,1,a,1", (Object)RowToCsvCSVFormatTest.rowToCsv(CsvIOTestData.DATA.allPrimitiveDataTypesRowWithPadding, RowToCsvCSVFormatTest.csvFormat(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA).withTrim(true)));
    }

    private static SerializableFunction<Row, String> rowToCsvFn(Schema schema, CSVFormat csvFormat) {
        return CsvRowConversions.RowToCsv.builder().setCSVFormat(csvFormat).setSchema(schema).build();
    }

    private static String rowToCsv(Row row, CSVFormat csvFormat) {
        Schema schema = (Schema)Preconditions.checkNotNull((Object)row.getSchema());
        return (String)RowToCsvCSVFormatTest.rowToCsvFn(schema, csvFormat).apply((Object)row);
    }

    private static CSVFormat csvFormat(Schema schema) {
        return CSVFormat.DEFAULT.withHeader(schema.sorted().getFieldNames().toArray(new String[0]));
    }
}

