/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.common.SchemaAwareJavaBeans;
import org.apache.beam.sdk.io.csv.CsvIO;
import org.apache.beam.sdk.io.csv.CsvIOTestData;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.commons.csv.CSVFormat;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CsvIOWriteTest {
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TestPipeline errorPipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void headersWithCommentsWrittenFirstOnEachShard() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "headersWithCommentsWrittenFirstOnEachShard");
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        String expectedHeader = "aBoolean,aDecimal,aDouble,aFloat,aLong,aString,anInteger";
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeaderComments(new Object[]{"foo", "bar", "baz"}).withCommentMarker('#');
        input.apply((PTransform)CsvIO.writeRows((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(3)));
        this.writePipeline.run().waitUntilFinish();
        PCollection files = (PCollection)((PCollection)this.readPipeline.apply((PTransform)FileIO.match().filepattern(CsvIOWriteTest.toFilenamePrefix(folder) + "*"))).apply((PTransform)FileIO.readMatches());
        PAssert.that((PCollection)files).satisfies((SerializableFunction & Serializable)itr -> {
            Iterable safeItr = Objects.requireNonNull(itr);
            for (FileIO.ReadableFile file : safeItr) {
                try {
                    List lines = Splitter.on((char)'\n').splitToList((CharSequence)file.readFullyAsUTF8String());
                    Assert.assertFalse((boolean)lines.isEmpty());
                    Assert.assertEquals((Object)"# foo", lines.get(0));
                    Assert.assertEquals((Object)"# bar", lines.get(1));
                    Assert.assertEquals((Object)"# baz", lines.get(2));
                    Assert.assertEquals((Object)expectedHeader, lines.get(3));
                    Assert.assertTrue((boolean)lines.subList(4, lines.size()).stream().noneMatch(expectedHeader::equals));
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            return null;
        });
        this.readPipeline.run();
    }

    @Test
    public void headersWrittenFirstOnEachShard() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "headersWrittenFirstOnEachShard");
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        String expectedHeader = "aBoolean,aDecimal,aDouble,aFloat,aLong,aString,anInteger";
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        input.apply((PTransform)CsvIO.writeRows((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(3)));
        this.writePipeline.run().waitUntilFinish();
        PCollection files = (PCollection)((PCollection)this.readPipeline.apply((PTransform)FileIO.match().filepattern(CsvIOWriteTest.toFilenamePrefix(folder) + "*"))).apply((PTransform)FileIO.readMatches());
        PAssert.that((PCollection)files).satisfies((SerializableFunction & Serializable)itr -> {
            Iterable safeItr = Objects.requireNonNull(itr);
            for (FileIO.ReadableFile file : safeItr) {
                try {
                    List lines = Splitter.on((char)'\n').splitToList((CharSequence)file.readFullyAsUTF8String());
                    Assert.assertFalse((boolean)lines.isEmpty());
                    Assert.assertEquals((Object)expectedHeader, lines.get(0));
                    Assert.assertTrue((boolean)lines.subList(1, lines.size()).stream().noneMatch(expectedHeader::equals));
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            return null;
        });
        this.readPipeline.run();
    }

    @Test
    public void writesUserDefinedTypes() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "writesUserDefinedTypes");
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of((Object)SchemaAwareJavaBeans.allPrimitiveDataTypes((Boolean)false, (BigDecimal)BigDecimal.TEN, (Double)1.0, (Float)Float.valueOf(1.0f), (Integer)1, (Long)1L, (String)"a"), (Object[])new SchemaAwareJavaBeans.AllPrimitiveDataTypes[]{SchemaAwareJavaBeans.allPrimitiveDataTypes((Boolean)false, (BigDecimal)BigDecimal.TEN.add(BigDecimal.TEN), (Double)2.0, (Float)Float.valueOf(2.0f), (Integer)2, (Long)2L, (String)"b"), SchemaAwareJavaBeans.allPrimitiveDataTypes((Boolean)false, (BigDecimal)BigDecimal.TEN.add(BigDecimal.TEN).add(BigDecimal.TEN), (Double)3.0, (Float)Float.valueOf(3.0f), (Integer)3, (Long)3L, (String)"c")}));
        String expectedHeader = "aBoolean,aDecimal,aDouble,aFloat,aLong,aString,anInteger";
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        input.apply((PTransform)CsvIO.write((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(1)));
        this.writePipeline.run().waitUntilFinish();
        PAssert.that((PCollection)((PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(CsvIOWriteTest.toFilenamePrefix(folder) + "*")))).containsInAnyOrder((Object[])new String[]{expectedHeader, "false,10,1.0,1.0,1,a,1", "false,20,2.0,2.0,2,b,2", "false,30,3.0,3.0,3,c,3"});
        this.readPipeline.run();
    }

    @Test
    public void nonNullCSVFormatHeaderWritesSelectedSchemaFields() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "nonNullCSVFormatHeaderWritesSelectedSchemaFields");
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        String expectedHeader = "aFloat,aString,aDecimal";
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[]{"aFloat", "aString", "aDecimal"});
        input.apply((PTransform)CsvIO.writeRows((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(1)));
        this.writePipeline.run().waitUntilFinish();
        PAssert.that((PCollection)((PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(CsvIOWriteTest.toFilenamePrefix(folder) + "*")))).containsInAnyOrder((Object[])new String[]{expectedHeader, "1.0,a,10", "2.0,b,20", "3.0,c,30"});
        this.readPipeline.run();
    }

    @Test
    public void withSkipHeaderRecordOnlyWritesRows() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "withSkipHeaderRecordWritesCsvFilesWithoutHeaders");
        CSVFormat csvFormat = CSVFormat.DEFAULT.withSkipHeaderRecord();
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        input.apply((PTransform)CsvIO.writeRows((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(1)));
        this.writePipeline.run().waitUntilFinish();
        PAssert.that((PCollection)((PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(CsvIOWriteTest.toFilenamePrefix(folder) + "*")))).containsInAnyOrder((Object[])new String[]{"false,10,1.0,1.0,1,a,1", "false,20,2.0,2.0,2,b,2", "false,30,3.0,3.0,3,c,3"});
        this.readPipeline.run();
    }

    @Test
    public void nullCSVFormatHeaderWritesAllSchemaFields() {
        File folder = this.createFolder(SchemaAwareJavaBeans.AllPrimitiveDataTypes.class.getSimpleName(), "nullCSVFormatHeaderWritesAllSchemaFields");
        PCollection input = (PCollection)this.writePipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        String expectedHeader = "aBoolean,aDecimal,aDouble,aFloat,aLong,aString,anInteger";
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        input.apply((PTransform)CsvIO.writeRows((String)CsvIOWriteTest.toFilenamePrefix(folder), (CSVFormat)csvFormat).withNumShards(Integer.valueOf(1)));
        this.writePipeline.run().waitUntilFinish();
        PAssert.that((PCollection)((PCollection)this.readPipeline.apply((PTransform)TextIO.read().from(CsvIOWriteTest.toFilenamePrefix(folder) + "*")))).containsInAnyOrder((Object[])new String[]{expectedHeader, "false,10,1.0,1.0,1,a,1", "false,20,2.0,2.0,2,b,2", "false,30,3.0,3.0,3,c,3"});
        this.readPipeline.run();
    }

    @Test
    public void nonNullHeaderCommentsRequiresHeaderMarker() {
        PCollection input = (PCollection)this.errorPipeline.apply((PTransform)Create.of(CsvIOTestData.DATA.allPrimitiveDataTypeRows).withRowSchema(SchemaAwareJavaBeans.ALL_PRIMITIVE_DATA_TYPES_SCHEMA));
        IllegalArgumentException nullHeaderMarker = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            WriteFilesResult cfr_ignored_0 = (WriteFilesResult)input.apply((PTransform)CsvIO.writeRows((String)"somewhere", (CSVFormat)CSVFormat.DEFAULT.withHeaderComments(new Object[]{"some", "header", "comments"})));
        });
        Assert.assertEquals((Object)"CSVFormat withCommentMarker required when withHeaderComments", (Object)nullHeaderMarker.getMessage());
    }

    private static String toFilenamePrefix(File folder) {
        Preconditions.checkArgument((boolean)folder.isDirectory());
        return folder.getAbsolutePath() + "/out";
    }

    private File createFolder(String ... paths) {
        try {
            return this.tempFolder.newFolder(paths);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

