/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import java.util.HashMap;
import org.apache.beam.sdk.io.csv.CsvIO;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.commons.csv.CSVFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CsvIOWriteDisplayDataTest {
    private static final String CRLF = "\r\n";

    @Test
    public void csvFormatNotPredefined() {
        CSVFormat csvFormat = CSVFormat.newFormat((char)',');
        CsvIOWriteDisplayDataTest.assertDisplayDataEquals((ImmutableMap<String, Object>)ImmutableMap.of((Object)"trim", (Object)false, (Object)"delimiter", (Object)",", (Object)"allowDuplicateHeaderNames", (Object)true, (Object)"trailingDelimiter", (Object)false), DisplayData.from((HasDisplayData)CsvIO.write((String)"somewhere", (CSVFormat)csvFormat)), "CSVFormat from newFormat");
    }

    @Test
    public void defaultPredefinedCsvFormat() {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        CsvIOWriteDisplayDataTest.assertDisplayDataEquals((ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)"recordSeparator", (Object)CRLF).put((Object)"quoteCharacter", (Object)"\"").put((Object)"allowDuplicateHeaderNames", (Object)true).put((Object)"delimiter", (Object)",").put((Object)"trim", (Object)false).put((Object)"trailingDelimiter", (Object)false).build(), DisplayData.from((HasDisplayData)CsvIO.write((String)"somewhere", (CSVFormat)csvFormat)), CSVFormat.Predefined.Default.name());
    }

    private static void assertDisplayDataEquals(ImmutableMap<String, Object> expected, DisplayData actual, String message) {
        HashMap<String, Object> actualMap = new HashMap<String, Object>();
        for (DisplayData.Item item : actual.items()) {
            actualMap.put(item.getKey(), item.getValue());
        }
        Assert.assertEquals((String)message, expected, actualMap);
    }
}

