/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.csv.CsvIO;
import org.apache.beam.sdk.io.csv.providers.AutoValue_CsvWriteTransformProvider_CsvWriteConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class CsvWriteTransformProvider
extends TypedSchemaTransformProvider<CsvWriteConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized String WRITE_RESULTS = "output";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized CsvWriteConfiguration> configurationClass() {
        return CsvWriteConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized CsvWriteConfiguration configuration) {
        return new CsvWriteTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("beam:schematransform:org.apache.beam:csv_write:v1", new Object[0]);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(WRITE_RESULTS);
    }

    protected static class CsvWriteTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized CsvWriteConfiguration configuration;

        CsvWriteTransform(@UnknownKeyFor @NonNull @Initialized CsvWriteConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            CSVFormat format = CSVFormat.DEFAULT;
            if (this.configuration.getDelimiter() != null) {
                format = format.withDelimiter(this.configuration.getDelimiter().charAt(0));
            }
            WriteFilesResult result = (WriteFilesResult)input.get(CsvWriteTransformProvider.INPUT_ROWS_TAG).apply(CsvIO.writeRows(this.configuration.getPath(), format).withSuffix(""));
            Schema outputSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"filename", (Schema.FieldType)Schema.FieldType.STRING)});
            return PCollectionRowTuple.of((String)CsvWriteTransformProvider.WRITE_RESULTS, (PCollection)((PCollection)result.getPerDestinationOutputFilenames().apply("Collect filenames", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)destinationAndRow -> Row.withSchema((Schema)outputSchema).withFieldValue("filename", destinationAndRow.getValue()).build()))).setRowSchema(outputSchema));
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class CsvWriteConfiguration {
        public void validate() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getPath()) ? 1 : 0) != 0, (Object)"Path for a CSV Write must be specified.");
            Preconditions.checkArgument((this.getDelimiter() == null || this.getDelimiter().length() == 1 ? 1 : 0) != 0, (Object)("Only single-character delimiters supported, got '" + this.getDelimiter() + "'"));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_CsvWriteTransformProvider_CsvWriteConfiguration.Builder();
        }

        @SchemaFieldDescription(value="The file path to write to.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getPath();

        @SchemaFieldDescription(value="The field delimiter to use when writing records. Defaults to a comma.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getDelimiter();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setPath(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiter(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized CsvWriteConfiguration build();
        }
    }
}

