/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv.providers;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.csv.providers.CsvWriteTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_CsvWriteTransformProvider_CsvWriteConfiguration
extends CsvWriteTransformProvider.CsvWriteConfiguration {
    private final String path;
    private final String delimiter;

    private AutoValue_CsvWriteTransformProvider_CsvWriteConfiguration(String path, @Nullable String delimiter) {
        this.path = path;
        this.delimiter = delimiter;
    }

    @Override
    @SchemaFieldDescription(value="The file path to write to.")
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The field delimiter to use when writing records. Defaults to a comma.")
    public String getDelimiter() {
        return this.delimiter;
    }

    public String toString() {
        return "CsvWriteConfiguration{path=" + this.path + ", delimiter=" + this.delimiter + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CsvWriteTransformProvider.CsvWriteConfiguration) {
            CsvWriteTransformProvider.CsvWriteConfiguration that = (CsvWriteTransformProvider.CsvWriteConfiguration)o;
            return this.path.equals(that.getPath()) && (this.delimiter == null ? that.getDelimiter() == null : this.delimiter.equals(that.getDelimiter()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.path.hashCode();
        h$ *= 1000003;
        return h$ ^= this.delimiter == null ? 0 : this.delimiter.hashCode();
    }

    static final class Builder
    extends CsvWriteTransformProvider.CsvWriteConfiguration.Builder {
        private String path;
        private String delimiter;

        Builder() {
        }

        @Override
        public CsvWriteTransformProvider.CsvWriteConfiguration.Builder setPath(String path) {
            if (path == null) {
                throw new NullPointerException("Null path");
            }
            this.path = path;
            return this;
        }

        @Override
        public CsvWriteTransformProvider.CsvWriteConfiguration.Builder setDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public CsvWriteTransformProvider.CsvWriteConfiguration build() {
            if (this.path == null) {
                String missing = " path";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CsvWriteTransformProvider_CsvWriteConfiguration(this.path, this.delimiter);
        }
    }
}

