/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.csv.AutoValue_CsvRowConversions_RowToCsv;
import org.apache.beam.sdk.io.csv.CsvIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class CsvRowConversions {
    CsvRowConversions() {
    }

    private static void validateCSVFormat(@UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat) {
        String[] header = (String[])Preconditions.checkNotNull((Object)csvFormat.getHeader(), (Object)"CSVFormat withHeader is required");
        Preconditions.checkArgument((header.length > 0 ? 1 : 0) != 0, (Object)"CSVFormat withHeader requires at least one column");
        Preconditions.checkArgument((!csvFormat.getAutoFlush() ? 1 : 0) != 0, (Object)"withAutoFlush is an illegal CSVFormat setting");
        Preconditions.checkArgument((!csvFormat.getIgnoreHeaderCase() ? 1 : 0) != 0, (Object)"withIgnoreHeaderCase is an illegal CSVFormat setting");
        Preconditions.checkArgument((!csvFormat.getAllowMissingColumnNames() ? 1 : 0) != 0, (Object)"withAllowMissingColumnNames is an illegal CSVFormat setting");
        Preconditions.checkArgument((!csvFormat.getIgnoreSurroundingSpaces() ? 1 : 0) != 0, (Object)"withIgnoreSurroundingSpaces is an illegal CSVFormat setting");
    }

    private static void validateHeaderAgainstSchema(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] csvHeader, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        HashSet<String> distinctColumns = new HashSet<String>(Arrays.asList(csvHeader));
        ArrayList<String> mismatchColumns = new ArrayList<String>();
        ArrayList<String> invalidTypes = new ArrayList<String>();
        Set validTypeNames = CsvIO.VALID_FIELD_TYPE_SET.stream().map(Schema.FieldType::getTypeName).collect(Collectors.toSet());
        for (String column : distinctColumns) {
            if (!schema.hasField(column)) {
                mismatchColumns.add(column);
                continue;
            }
            Schema.TypeName typeName = schema.getField(column).getType().getTypeName();
            if (validTypeNames.contains(typeName)) continue;
            invalidTypes.add(column);
        }
        Preconditions.checkArgument((boolean)mismatchColumns.isEmpty(), (String)"columns in CSVFormat header do not exist in Schema: %s", (Object)String.join((CharSequence)",", mismatchColumns));
        Preconditions.checkArgument((boolean)invalidTypes.isEmpty(), (String)"columns in header match fields in Schema with invalid types: %s. See CsvIO#VALID_FIELD_TYPE_SET for a list of valid field types.", (Object)String.join((CharSequence)",", invalidTypes));
    }

    @AutoValue
    static abstract class RowToCsv
    implements SerializableFunction<Row, String> {
        RowToCsv() {
        }

        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_CsvRowConversions_RowToCsv.Builder();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Schema getSchema();

        abstract @UnknownKeyFor @NonNull @Initialized CSVFormat getCSVFormat();

        public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            Row safeInput = (Row)Preconditions.checkNotNull((Object)input);
            String[] header = this.getHeader();
            Object[] values = new Object[header.length];
            for (int i = 0; i < header.length; ++i) {
                values[i] = safeInput.getValue(header[i]);
            }
            return this.getCSVFormat().format(values);
        }

        @NonNull @UnknownKeyFor @Initialized String @UnknownKeyFor @NonNull @Initialized [] getHeader() {
            return (String[])Preconditions.checkNotNull((Object)this.getCSVFormat().getHeader());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

            abstract @UnknownKeyFor @NonNull @Initialized Schema getSchema();

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCSVFormat(@UnknownKeyFor @NonNull @Initialized CSVFormat var1);

            abstract @UnknownKeyFor @NonNull @Initialized CSVFormat getCSVFormat();

            abstract @UnknownKeyFor @NonNull @Initialized RowToCsv autoBuild();

            final @UnknownKeyFor @NonNull @Initialized RowToCsv build() {
                Preconditions.checkArgument((this.getSchema().getFieldCount() > 0 ? 1 : 0) != 0, (Object)"Schema has no fields");
                this.setCSVFormat(this.getCSVFormat().withSkipHeaderRecord().withRecordSeparator(' ').withHeaderComments(new Object[0]));
                CsvRowConversions.validateCSVFormat(this.getCSVFormat());
                CsvRowConversions.validateHeaderAgainstSchema(this.getCSVFormat().getHeader(), this.getSchema());
                return this.autoBuild();
            }
        }
    }
}

