/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.csv;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.csv.AutoValue_CsvIO_Write;
import org.apache.beam.sdk.io.csv.CsvRowConversions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.commons.csv.CSVFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CsvIO {
    public static final @UnknownKeyFor @NonNull @Initialized Set<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType> VALID_FIELD_TYPE_SET = ImmutableSet.of((Object)Schema.FieldType.BYTE, (Object)Schema.FieldType.BOOLEAN, (Object)Schema.FieldType.DATETIME, (Object)Schema.FieldType.DECIMAL, (Object)Schema.FieldType.DOUBLE, (Object)Schema.FieldType.INT16, (Object[])new Schema.FieldType[]{Schema.FieldType.INT32, Schema.FieldType.INT64, Schema.FieldType.FLOAT, Schema.FieldType.STRING});
    static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_FILENAME_SUFFIX = ".csv";

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write(@UnknownKeyFor @NonNull @Initialized String to, @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat) {
        return new AutoValue_CsvIO_Write.Builder().setTextIOWrite(CsvIO.createDefaultTextIOWrite(to)).setCSVFormat(csvFormat).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized Row> writeRows(@UnknownKeyFor @NonNull @Initialized String to, @UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat) {
        return new AutoValue_CsvIO_Write.Builder().setTextIOWrite(CsvIO.createDefaultTextIOWrite(to)).setCSVFormat(csvFormat).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TextIO.Write createDefaultTextIOWrite(@UnknownKeyFor @NonNull @Initialized String to) {
        return TextIO.write().to(to).withSuffix(DEFAULT_FILENAME_SUFFIX);
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, WriteFilesResult<String>>
    implements HasDisplayData {
        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CSVFormat csvFormat = this.getCSVFormat();
            builder.add(DisplayData.item((String)"delimiter", (String)String.valueOf(csvFormat.getDelimiter())));
            if (csvFormat.getQuoteCharacter() != null) {
                builder.add(DisplayData.item((String)"quoteCharacter", (String)String.valueOf(csvFormat.getQuoteCharacter())));
            }
            if (csvFormat.getQuoteMode() != null) {
                builder.add(DisplayData.item((String)"quoteMode", (String)csvFormat.getQuoteMode().toString()));
            }
            if (csvFormat.getCommentMarker() != null) {
                builder.add(DisplayData.item((String)"commentMarker", (String)csvFormat.getCommentMarker().toString()));
            }
            if (csvFormat.getEscapeCharacter() != null) {
                builder.add(DisplayData.item((String)"escapeCharacter", (String)csvFormat.getEscapeCharacter().toString()));
            }
            builder.addIfNotNull(DisplayData.item((String)"recordSeparator", (String)csvFormat.getRecordSeparator()));
            builder.addIfNotNull(DisplayData.item((String)"nullString", (String)csvFormat.getNullString()));
            if (csvFormat.getHeaderComments() != null) {
                builder.add(DisplayData.item((String)"headerComments", (String)String.join((CharSequence)"\n", csvFormat.getHeaderComments())));
            }
            if (csvFormat.getHeader() != null) {
                builder.add(DisplayData.item((String)"header", (String)String.join((CharSequence)",", csvFormat.getHeader())));
            }
            builder.addIfNotNull(DisplayData.item((String)"trailingDelimiter", (Boolean)csvFormat.getTrailingDelimiter()));
            builder.addIfNotNull(DisplayData.item((String)"trim", (Boolean)csvFormat.getTrim()));
            builder.addIfNotNull(DisplayData.item((String)"allowDuplicateHeaderNames", (Boolean)csvFormat.getAllowDuplicateHeaderNames()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withCompression(compression)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNoSpilling() {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withNoSpilling()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNumShards(@UnknownKeyFor @NonNull @Initialized Integer numShards) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withNumShards(numShards.intValue())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withoutSharding() {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withoutSharding()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withShardTemplate(@UnknownKeyFor @NonNull @Initialized String shardTemplate) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withShardNameTemplate(shardTemplate)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSuffix(@UnknownKeyFor @NonNull @Initialized String suffix) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withSuffix(suffix)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ResourceId tempDirectory) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withTempDirectory(tempDirectory)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWindowedWrites() {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withWindowedWrites()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWritableByteChannelFactory(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized FileBasedSink.WritableByteChannelFactory writableByteChannelFactory) {
            return this.toBuilder().setTextIOWrite(this.getTextIOWrite().withWritableByteChannelFactory(writableByteChannelFactory)).build();
        }

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TextIO.Write getTextIOWrite();

        abstract @UnknownKeyFor @NonNull @Initialized CSVFormat getCSVFormat();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (!input.hasSchema()) {
                throw new IllegalArgumentException(String.format("%s requires an input Schema. Note that only Row or user classes are supported. Consider using TextIO or FileIO directly when writing primitive types", Write.class.getName()));
            }
            Schema schema = input.getSchema();
            RowCoder rowCoder = RowCoder.of((Schema)schema);
            PCollection rows = ((PCollection)input.apply("To Rows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via(input.getToRowFunction()))).setCoder((Coder)rowCoder);
            CSVFormat csvFormat = Write.buildHeaderFromSchemaIfNeeded(this.getCSVFormat(), schema);
            TextIO.Write write = this.getTextIOWrite();
            write = Write.writeWithCSVFormatHeaderAndComments(csvFormat, write);
            CsvRowConversions.RowToCsv toCsvFn = CsvRowConversions.RowToCsv.builder().setCSVFormat(csvFormat).setSchema(input.getSchema()).build();
            PCollection csv = (PCollection)rows.apply("To CSV", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction)toCsvFn));
            return (WriteFilesResult)csv.apply("Write CSV", (PTransform)write.withOutputFilenames());
        }

        private static @UnknownKeyFor @NonNull @Initialized CSVFormat buildHeaderFromSchemaIfNeeded(@UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (csvFormat.getHeader() == null) {
                csvFormat = csvFormat.withHeader(schema.sorted().getFieldNames().toArray(new String[0]));
            }
            return csvFormat;
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TextIO.Write writeWithCSVFormatHeaderAndComments(@UnknownKeyFor @NonNull @Initialized CSVFormat csvFormat, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TextIO.Write write) {
            if (csvFormat.getSkipHeaderRecord()) {
                return write;
            }
            String[] header = Objects.requireNonNull(csvFormat.getHeader());
            ArrayList<String> result = new ArrayList<String>();
            if (csvFormat.getHeaderComments() != null) {
                for (String comment : csvFormat.getHeaderComments()) {
                    result.add(csvFormat.getCommentMarker() + " " + comment);
                }
            }
            CSVFormat withHeaderCommentsRemoved = csvFormat.withHeaderComments(new Object[0]);
            result.add(withHeaderCommentsRemoved.withSkipHeaderRecord().format((Object[])header));
            return write.withHeader(String.join((CharSequence)"\n", result));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTextIOWrite(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized TextIO.Write var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCSVFormat(@UnknownKeyFor @NonNull @Initialized CSVFormat var1);

            abstract @UnknownKeyFor @NonNull @Initialized CSVFormat getCSVFormat();

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> autoBuild();

            final @UnknownKeyFor @NonNull @Initialized Write<T> build() {
                if (this.getCSVFormat().getHeaderComments() != null) {
                    Preconditions.checkArgument((boolean)this.getCSVFormat().isCommentMarkerSet(), (Object)"CSVFormat withCommentMarker required when withHeaderComments");
                }
                return this.autoBuild();
            }
        }
    }
}

