/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.contextualtextio;

import java.util.Arrays;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.contextualtextio.ContextualTextIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ContextualTextIO_Read
extends ContextualTextIO.Read {
    private final @Nullable ValueProvider<String> filepattern;
    private final FileIO.MatchConfiguration matchConfiguration;
    private final boolean hintMatchesManyFiles;
    private final boolean withRecordNumMetadata;
    private final Compression compression;
    private final @Nullable Boolean hasMultilineCSVRecords;
    private final byte @Nullable [] delimiter;

    private AutoValue_ContextualTextIO_Read(@Nullable ValueProvider<String> filepattern, FileIO.MatchConfiguration matchConfiguration, boolean hintMatchesManyFiles, boolean withRecordNumMetadata, Compression compression, @Nullable Boolean hasMultilineCSVRecords, byte @Nullable [] delimiter) {
        this.filepattern = filepattern;
        this.matchConfiguration = matchConfiguration;
        this.hintMatchesManyFiles = hintMatchesManyFiles;
        this.withRecordNumMetadata = withRecordNumMetadata;
        this.compression = compression;
        this.hasMultilineCSVRecords = hasMultilineCSVRecords;
        this.delimiter = delimiter;
    }

    @Override
    @Nullable ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    FileIO.MatchConfiguration getMatchConfiguration() {
        return this.matchConfiguration;
    }

    @Override
    boolean getHintMatchesManyFiles() {
        return this.hintMatchesManyFiles;
    }

    @Override
    boolean getWithRecordNumMetadata() {
        return this.withRecordNumMetadata;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    @Nullable Boolean getHasMultilineCSVRecords() {
        return this.hasMultilineCSVRecords;
    }

    @Override
    byte @Nullable [] getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ContextualTextIO.Read) {
            ContextualTextIO.Read that = (ContextualTextIO.Read)((Object)o);
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && this.matchConfiguration.equals(that.getMatchConfiguration()) && this.hintMatchesManyFiles == that.getHintMatchesManyFiles() && this.withRecordNumMetadata == that.getWithRecordNumMetadata() && this.compression.equals((Object)that.getCompression()) && (this.hasMultilineCSVRecords == null ? that.getHasMultilineCSVRecords() == null : this.hasMultilineCSVRecords.equals(that.getHasMultilineCSVRecords())) && Arrays.equals(this.delimiter, that instanceof AutoValue_ContextualTextIO_Read ? ((AutoValue_ContextualTextIO_Read)that).delimiter : that.getDelimiter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.matchConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.hintMatchesManyFiles ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.withRecordNumMetadata ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        h$ ^= this.hasMultilineCSVRecords == null ? 0 : this.hasMultilineCSVRecords.hashCode();
        h$ *= 1000003;
        return h$ ^= Arrays.hashCode(this.delimiter);
    }

    @Override
    ContextualTextIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ContextualTextIO.Read.Builder {
        private @Nullable ValueProvider<String> filepattern;
        private FileIO.MatchConfiguration matchConfiguration;
        private Boolean hintMatchesManyFiles;
        private Boolean withRecordNumMetadata;
        private Compression compression;
        private @Nullable Boolean hasMultilineCSVRecords;
        private byte @Nullable [] delimiter;

        Builder() {
        }

        private Builder(ContextualTextIO.Read source) {
            this.filepattern = source.getFilepattern();
            this.matchConfiguration = source.getMatchConfiguration();
            this.hintMatchesManyFiles = source.getHintMatchesManyFiles();
            this.withRecordNumMetadata = source.getWithRecordNumMetadata();
            this.compression = source.getCompression();
            this.hasMultilineCSVRecords = source.getHasMultilineCSVRecords();
            this.delimiter = source.getDelimiter();
        }

        @Override
        ContextualTextIO.Read.Builder setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            if (matchConfiguration == null) {
                throw new NullPointerException("Null matchConfiguration");
            }
            this.matchConfiguration = matchConfiguration;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setHintMatchesManyFiles(boolean hintMatchesManyFiles) {
            this.hintMatchesManyFiles = hintMatchesManyFiles;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setWithRecordNumMetadata(boolean withRecordNumMetadata) {
            this.withRecordNumMetadata = withRecordNumMetadata;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setHasMultilineCSVRecords(Boolean hasMultilineCSVRecords) {
            this.hasMultilineCSVRecords = hasMultilineCSVRecords;
            return this;
        }

        @Override
        ContextualTextIO.Read.Builder setDelimiter(byte @Nullable [] delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        ContextualTextIO.Read build() {
            String missing = "";
            if (this.matchConfiguration == null) {
                missing = missing + " matchConfiguration";
            }
            if (this.hintMatchesManyFiles == null) {
                missing = missing + " hintMatchesManyFiles";
            }
            if (this.withRecordNumMetadata == null) {
                missing = missing + " withRecordNumMetadata";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ContextualTextIO_Read(this.filepattern, this.matchConfiguration, this.hintMatchesManyFiles, this.withRecordNumMetadata, this.compression, this.hasMultilineCSVRecords, this.delimiter);
        }
    }
}

